/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.syntax.constituent.type;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;

public class TreebankNodeUtil {
    public static TreebankNode selectMatchingLeaf(JCas jCas, Annotation annotation) {
        TreebankNode leaf = null;
        for (TreebankNode node : JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (AnnotationFS)annotation)) {
            if (!node.getLeaf() || node.getBegin() != annotation.getBegin() || node.getEnd() != annotation.getEnd()) continue;
            if (leaf == null) {
                leaf = node;
                continue;
            }
            throw new IllegalArgumentException(String.format("expected one leaf matching annotation %s, found %s", annotation, Arrays.asList(leaf, node)));
        }
        return leaf;
    }

    public static TreebankNode selectHighestMatchingTreebankNode(JCas jCas, Annotation annotation) {
        TreebankNode highestNode = null;
        int smallestDepth = Integer.MAX_VALUE;
        for (TreebankNode node : JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (AnnotationFS)annotation)) {
            int depth;
            if (node.getBegin() != annotation.getBegin() || node.getEnd() != annotation.getEnd() || (depth = TreebankNodeUtil.getDepth(node)) >= smallestDepth) continue;
            highestNode = node;
            smallestDepth = depth;
        }
        return highestNode;
    }

    public static TreebankNode selectHighestCoveredTreebankNode(JCas jCas, Annotation annotation) {
        TreebankNode highestNode = null;
        int smallestDepth = Integer.MAX_VALUE;
        for (TreebankNode node : JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (AnnotationFS)annotation)) {
            int depth;
            if (annotation.getBegin() > node.getBegin() || node.getEnd() > annotation.getEnd() || (depth = TreebankNodeUtil.getDepth(node)) >= smallestDepth) continue;
            highestNode = node;
            smallestDepth = depth;
        }
        return highestNode;
    }

    public static int getDepth(TreebankNode node) {
        int depth = -1;
        while (node != null) {
            ++depth;
            node = node.getParent();
        }
        return depth;
    }

    public static List<TreebankNode> getPathToRoot(TreebankNode startNode) {
        ArrayList<TreebankNode> nlist = new ArrayList<TreebankNode>(20);
        for (TreebankNode cursorNode = startNode; cursorNode != null; cursorNode = cursorNode.getParent()) {
            nlist.add(cursorNode);
        }
        return nlist;
    }

    public static TreebankNodePath getPath(TreebankNode source, TreebankNode target) {
        List<TreebankNode> sourceToRoot = TreebankNodeUtil.getPathToRoot(source);
        List<TreebankNode> targetToRoot = TreebankNodeUtil.getPathToRoot(target);
        TreebankNode ancestor = null;
        while (sourceToRoot.size() > 0 && targetToRoot.size() > 0 && sourceToRoot.get(sourceToRoot.size() - 1) == targetToRoot.get(targetToRoot.size() - 1)) {
            ancestor = sourceToRoot.remove(sourceToRoot.size() - 1);
            ancestor = targetToRoot.remove(targetToRoot.size() - 1);
        }
        return new TreebankNodePath(ancestor, sourceToRoot, targetToRoot);
    }

    public static String toTreebankString(TreebankNode node) {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(node.getNodeType());
        if (node.getLeaf()) {
            builder.append(' ').append(node.getCoveredText());
        } else {
            for (TreebankNode child : JCasUtil.select((FSArray)node.getChildren(), TreebankNode.class)) {
                builder.append(' ').append(TreebankNodeUtil.toTreebankString(child));
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static TreebankNode getParent(TreebankNode node) {
        if (node != null) {
            node = node.getParent();
        }
        return node;
    }

    public static TreebankNode getAncestorWithType(TreebankNode node, String type) {
        while (node != null && !node.getNodeType().equals(type)) {
            node = node.getParent();
        }
        return node;
    }

    public static TreebankNode newNode(JCas jCas, int begin, int end, String nodeType) {
        TreebankNode node = new TreebankNode(jCas, begin, end);
        node.setNodeType(nodeType);
        node.setChildren(new FSArray(jCas, 0));
        node.setLeaf(true);
        node.addToIndexes();
        return node;
    }

    public static TreebankNode newNode(JCas jCas, String nodeType, TreebankNode ... children) {
        int begin = children[0].getBegin();
        int end = children[children.length - 1].getEnd();
        TreebankNode node = new TreebankNode(jCas, begin, end);
        node.setNodeType(nodeType);
        node.addToIndexes();
        FSArray fsArray = new FSArray(jCas, children.length);
        fsArray.copyFromArray((FeatureStructure[])children, 0, 0, children.length);
        node.setChildren(fsArray);
        for (TreebankNode child : children) {
            child.setParent(node);
        }
        return node;
    }

    public static TopTreebankNode getTopNode(TreebankNode node) {
        if (node instanceof TopTreebankNode) {
            return (TopTreebankNode)node;
        }
        TreebankNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof TopTreebankNode) {
                return (TopTreebankNode)parent;
            }
            node = parent;
            parent = node.getParent();
        }
        return null;
    }

    public static void print(PrintStream out, TreebankNode node) {
        out.println(TreebankNodeUtil.print(node, 0));
    }

    private static String print(TreebankNode node, int tabs) {
        StringBuffer returnValue = new StringBuffer();
        String tabString = TreebankNodeUtil.getTabs(tabs);
        returnValue.append(tabString + node.getNodeType());
        if (node.getNodeValue() != null) {
            returnValue.append(":" + node.getNodeValue() + "\n");
        } else {
            returnValue.append(":" + node.getCoveredText() + "\n");
        }
        if (node.getChildren().size() > 0) {
            Collection children = JCasUtil.select((FSArray)node.getChildren(), TreebankNode.class);
            for (TreebankNode child : children) {
                returnValue.append(TreebankNodeUtil.print(child, tabs + 1));
            }
        }
        return returnValue.toString();
    }

    private static String getTabs(int tabs) {
        char[] chars = new char[tabs];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    public static class TreebankNodePath {
        private List<TreebankNode> sourceToAncestor;
        private TreebankNode commonAncestor;
        private List<TreebankNode> targetToAncestor;

        public TreebankNodePath(TreebankNode commonAncestor, List<TreebankNode> sourceToAncestor, List<TreebankNode> targetToAncestor) {
            this.commonAncestor = commonAncestor;
            this.sourceToAncestor = sourceToAncestor;
            this.targetToAncestor = targetToAncestor;
        }

        public TreebankNode getCommonAncestor() {
            return this.commonAncestor;
        }

        public List<TreebankNode> getSourceToAncestorPath() {
            return this.sourceToAncestor;
        }

        public List<TreebankNode> getTargetToAncestorPath() {
            return this.targetToAncestor;
        }
    }
}

