/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;
import org.cleartk.corpus.timeml.PlainTextTlinkGoldAnnotator;
import org.cleartk.corpus.timeml.TempEval2013Writer;
import org.cleartk.corpus.timeml.TimeMlGoldAnnotator;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.eval.Evaluation_ImplBase;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.PosTaggerAnnotator;
import org.cleartk.opennlp.tools.SentenceAnnotator;
import org.cleartk.snowball.DefaultSnowballStemmer;
import org.cleartk.timeml.eval.Model;
import org.cleartk.timeml.event.EventAnnotator;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.timeml.time.TimeAnnotator;
import org.cleartk.timeml.time.TimeTypeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.tlink.TemporalLinkEventToDocumentCreationTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSameSentenceTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSubordinatedEventAnnotator;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Text;
import org.cleartk.timeml.type.Time;
import org.cleartk.token.tokenizer.TokenAnnotator;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class TempEval2013Evaluation
extends Evaluation_ImplBase<File, ImmutableTable<Model<?>, Model.Params, AnnotationStatistics<String>>> {
    private static Function<TemporalLink, List<Integer>> TEMPORAL_LINK_TO_SPANS = new Function<TemporalLink, List<Integer>>(){

        public List<Integer> apply(TemporalLink temporalLink) {
            Anchor source = temporalLink.getSource();
            Anchor target = temporalLink.getTarget();
            return source.getBegin() < target.getBegin() ? Lists.newArrayList((Object[])new Integer[]{source.getBegin(), source.getEnd(), target.getBegin(), target.getEnd()}) : Lists.newArrayList((Object[])new Integer[]{target.getBegin(), target.getEnd(), source.getBegin(), source.getEnd()});
        }
    };
    private static Function<TemporalLink, String> TEMPORAL_LINK_TO_RELATION = new Function<TemporalLink, String>(){

        public String apply(TemporalLink temporalLink) {
            Anchor source = temporalLink.getSource();
            Anchor target = temporalLink.getTarget();
            return source.getBegin() < target.getBegin() ? temporalLink.getRelationType() : TemporalLinkAnnotator_ImplBase.REVERSE_RELATION.get(temporalLink.getRelationType());
        }
    };
    private static List<Model.Params> SEQUENCE_CLASSIFIER_PARAM_SEARCH_SPACE = Lists.newArrayList((Object[])new Model.Params[]{new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "0.1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "0.5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "10", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "50", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "0.1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "0.5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "10", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 2, "-c", "50", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "0.1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "0.5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "10", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, 3, "-c", "50", "-s", "1")});
    private static List<Model.Params> CLASSIFIER_PARAM_SEARCH_SPACE = Lists.newArrayList((Object[])new Model.Params[]{new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.1", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.5", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "1", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "5", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "10", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "50", "-s", "0"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "1", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "5", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "10", "-s", "1"), new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "50", "-s", "1")});
    private static final Model<Time> TIME_EXTENT_MODEL = new Model<Time>("time-extent", Lists.newArrayList(), TimeAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, 1, "-c", "0.1", "-s", "1"), SEQUENCE_CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Time.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToNull(), null);
    private static final Model<Time> TIME_TYPE_MODEL = new Model<Time>("time-type", Lists.newArrayList((Object[])new Model[]{TIME_EXTENT_MODEL}), TimeTypeAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "5", "-s", "0"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Time.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"timeType"), "timeType");
    private static final Model<Event> EVENT_EXTENT_MODEL = new Model<Event>("event-extent", Lists.newArrayList(), EventAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.1", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToNull(), null);
    private static final Model<Event> EVENT_ASPECT_MODEL = new Model<Event>("event-aspect", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL}), EventAspectAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "5", "-s", "0"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"aspect"), "aspect");
    private static final Model<Event> EVENT_CLASS_MODEL = new Model<Event>("event-class", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL}), EventClassAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "5", "-s", "0"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"eventClass"), "eventClass");
    private static final Model<Event> EVENT_MODALITY_MODEL = new Model<Event>("event-modality", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL}), EventModalityAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "1", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"modality"), "modality");
    private static final Model<Event> EVENT_POLARITY_MODEL = new Model<Event>("event-polarity", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL}), EventPolarityAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "1", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"polarity"), "polarity");
    private static final Model<Event> EVENT_TENSE_MODEL = new Model<Event>("event-tense", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL}), EventTenseAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.5", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.NORMAL, Model.LoggingType.NONE, Event.class, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"tense"), "tense");
    private static final Model<TemporalLink> TLINK_EVENT_DOCTIME_MODEL = new Model<TemporalLink>("tlink-event-doctime", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL, EVENT_ASPECT_MODEL, EVENT_CLASS_MODEL, EVENT_MODALITY_MODEL, EVENT_POLARITY_MODEL, EVENT_TENSE_MODEL}), TemporalLinkEventToDocumentCreationTimeAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "50", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.INTERSECTED_SPANS, Model.LoggingType.NONE, TemporalLink.class, TEMPORAL_LINK_TO_SPANS, TEMPORAL_LINK_TO_RELATION, null);
    private static final Model<TemporalLink> TLINK_EVENT_SENTTIME_MODEL = new Model<TemporalLink>("tlink-event-senttime", Lists.newArrayList((Object[])new Model[]{TIME_EXTENT_MODEL, TIME_TYPE_MODEL, EVENT_EXTENT_MODEL, EVENT_ASPECT_MODEL, EVENT_CLASS_MODEL, EVENT_MODALITY_MODEL, EVENT_POLARITY_MODEL, EVENT_TENSE_MODEL}), TemporalLinkEventToSameSentenceTimeAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.5", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.INTERSECTED_SPANS, Model.LoggingType.NONE, TemporalLink.class, TEMPORAL_LINK_TO_SPANS, TEMPORAL_LINK_TO_RELATION, null);
    private static final Model<TemporalLink> TLINK_EVENT_SUBORDEVENT_MODEL = new Model<TemporalLink>("tlink-event-subordevent", Lists.newArrayList((Object[])new Model[]{EVENT_EXTENT_MODEL, EVENT_ASPECT_MODEL, EVENT_CLASS_MODEL, EVENT_MODALITY_MODEL, EVENT_POLARITY_MODEL, EVENT_TENSE_MODEL}), TemporalLinkEventToSubordinatedEventAnnotator.class, new Model.Params(LibLinearStringOutcomeDataWriter.class, "-c", "0.1", "-s", "1"), CLASSIFIER_PARAM_SEARCH_SPACE, Model.EvaluationType.INTERSECTED_SPANS, Model.LoggingType.NONE, TemporalLink.class, TEMPORAL_LINK_TO_SPANS, TEMPORAL_LINK_TO_RELATION, null);
    private ImmutableMultimap<Model<?>, Model.Params> models;
    private List<File> inferredTLinksDirectories;
    private boolean useVerbClauseTlinks;
    private boolean relationsOnly;

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> trainFiles = TempEval2013Evaluation.listAllFiles(options.getTrainDirectories());
        List<File> testFiles = TempEval2013Evaluation.listAllFiles(options.getTestDirectories());
        ArrayList allModels = Lists.newArrayList((Object[])new Model[]{TIME_EXTENT_MODEL, TIME_TYPE_MODEL, EVENT_EXTENT_MODEL, EVENT_ASPECT_MODEL, EVENT_CLASS_MODEL, EVENT_MODALITY_MODEL, EVENT_POLARITY_MODEL, EVENT_TENSE_MODEL, TLINK_EVENT_DOCTIME_MODEL, TLINK_EVENT_SENTTIME_MODEL, TLINK_EVENT_SUBORDEVENT_MODEL});
        HashMap nameToModel = Maps.newHashMap();
        for (Model model : allModels) {
            nameToModel.put(model.name, model);
        }
        ImmutableMultimap.Builder modelsBuilder = ImmutableMultimap.builder();
        String nameOfModelToTune = options.getNameOfModelToTune();
        if (nameOfModelToTune == null) {
            for (Model model : allModels) {
                if (options.getRelationsOnly() && !model.name.startsWith("tlink")) continue;
                modelsBuilder.put((Object)model, (Object)model.bestParams);
            }
        } else {
            Model modelToTune = (Model)nameToModel.get(nameOfModelToTune);
            if (modelToTune == null) {
                throw new IllegalArgumentException("No such model: " + nameOfModelToTune);
            }
            for (Model model : TempEval2013Evaluation.getSortedPrerequisites(modelToTune)) {
                if (options.getRelationsOnly() && !model.name.startsWith("tlink")) continue;
                modelsBuilder.put((Object)model, (Object)model.bestParams);
            }
            for (Model.Params params : modelToTune.paramsToSearch) {
                modelsBuilder.put((Object)modelToTune, (Object)params);
            }
        }
        ImmutableMultimap models = modelsBuilder.build();
        File evalDir = new File("target/tempeval2013");
        TempEval2013Evaluation tempEval2013Evaluation = new TempEval2013Evaluation(evalDir, models, options.getInferredTLinksDirectories(), options.getVerbClauseTLinks(), options.getRelationsOnly());
        if (options.getTrainOnly()) {
            if (!testFiles.isEmpty()) {
                throw new IllegalArgumentException("Cannot specify test files when only training");
            }
            tempEval2013Evaluation.train(tempEval2013Evaluation.getCollectionReader(trainFiles), Model.DEFAULT_DIRECTORY);
            for (Model model : models.keySet()) {
                for (Model.Params params : models.get((Object)model)) {
                    model.cleanTrainingFiles(Model.DEFAULT_DIRECTORY, params);
                }
            }
        } else {
            ImmutableTable modelStats;
            if (!testFiles.isEmpty()) {
                modelStats = (ImmutableTable)tempEval2013Evaluation.trainAndTest(trainFiles, testFiles);
            } else {
                List foldStats = tempEval2013Evaluation.crossValidation(trainFiles, 2);
                ImmutableTable.Builder modelStatsBuilder = ImmutableTable.builder();
                for (Model model : models.keySet()) {
                    for (Model.Params params : models.get((Object)model)) {
                        modelStatsBuilder.put((Object)model, (Object)params, (Object)new AnnotationStatistics());
                    }
                }
                modelStats = modelStatsBuilder.build();
                for (Table foldTable : foldStats) {
                    for (Table.Cell cell : foldTable.cellSet()) {
                        ((AnnotationStatistics)modelStats.get(cell.getRowKey(), cell.getColumnKey())).addAll((AnnotationStatistics)cell.getValue());
                    }
                }
            }
            for (Model model : models.keySet()) {
                for (Model.Params params : modelStats.row((Object)model).keySet()) {
                    System.err.printf("== %s %s ==\n", model.name, params);
                    System.err.println(modelStats.get((Object)model, (Object)params));
                }
            }
        }
    }

    private static List<File> listAllFiles(List<File> directories) {
        ArrayList files = Lists.newArrayList();
        if (directories != null) {
            for (File dir : directories) {
                for (File file : dir.listFiles()) {
                    if (file.getName().startsWith(".") || file.isHidden()) continue;
                    files.add(file);
                }
            }
        }
        return files;
    }

    private static Set<Model<?>> getPrerequisites(Model<?> model) {
        LinkedHashSet prereqs = Sets.newLinkedHashSet();
        for (Model<?> prereq : model.prerequisites) {
            prereqs.add(prereq);
            prereqs.addAll(TempEval2013Evaluation.getPrerequisites(prereq));
        }
        return prereqs;
    }

    private static LinkedHashSet<Model<?>> getSortedPrerequisites(Model<?> model) {
        ArrayDeque todo = Queues.newArrayDeque();
        LinkedHashMultimap following = LinkedHashMultimap.create();
        for (Model<?> prereq : TempEval2013Evaluation.getPrerequisites(model)) {
            if (prereq.prerequisites.isEmpty()) {
                todo.add(prereq);
                continue;
            }
            for (Model<?> preprereq : prereq.prerequisites) {
                following.put(preprereq, prereq);
            }
        }
        LinkedHashSet models = Sets.newLinkedHashSet();
        while (!todo.isEmpty()) {
            Model next = (Model)todo.iterator().next();
            todo.remove(next);
            models.add(next);
            for (Model<Object> prereq : following.removeAll((Object)next)) {
                if (following.containsKey(prereq)) continue;
                todo.add(prereq);
            }
        }
        return models;
    }

    public TempEval2013Evaluation(File baseDirectory, ImmutableMultimap<Model<?>, Model.Params> models, List<File> inferredTLinksDirectories, boolean useVerbClauseTlinks, boolean relationsOnly) {
        super(baseDirectory);
        this.models = models;
        this.inferredTLinksDirectories = inferredTLinksDirectories;
        this.useVerbClauseTlinks = useVerbClauseTlinks;
        this.relationsOnly = relationsOnly;
    }

    protected CollectionReader getCollectionReader(List<File> files) throws Exception {
        return UriCollectionReader.getCollectionReaderFromFiles(files);
    }

    public void train(CollectionReader reader, File directory) throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", "TimeMLView"}), new String[0]);
        builder.add(UriToDocumentTextAnnotator.getDescription(), new String[]{"_InitialView", "TimeMLView"});
        builder.add(TimeMlGoldAnnotator.getDescription(), new String[0]);
        if (this.inferredTLinksDirectories != null) {
            builder.add(AnalysisEngineFactory.createEngineDescription(UseInferredTlinks.class, (Object[])new Object[]{"InferredTLinksDirectories", this.inferredTLinksDirectories}), new String[0]);
        }
        if (this.useVerbClauseTlinks) {
            builder.add(PlainTextTlinkGoldAnnotator.getDescription(), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(FixTimeML.class, (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(SentenceAnnotator.class, (Object[])new Object[]{"sentenceModelPath", "/models/en-sent.bin", "windowClassNames", new Class[]{Text.class}}), new String[0]);
        builder.add(TokenAnnotator.getDescription(), new String[0]);
        builder.add(PosTaggerAnnotator.getDescription(), new String[0]);
        builder.add(DefaultSnowballStemmer.getDescription((String)"English"), new String[0]);
        builder.add(ParserAnnotator.getDescription(), new String[0]);
        for (Model model : this.models.keySet()) {
            for (Model.Params params : this.models.get((Object)model)) {
                builder.add(model.getWriterDescription(directory, params), new String[0]);
            }
        }
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{builder.createAggregate()});
        for (Model model : this.models.keySet()) {
            for (Model.Params params : this.models.get((Object)model)) {
                System.err.printf("Training: %s %s\n", model.name, params);
                model.train(directory, params);
            }
        }
    }

    protected ImmutableTable<Model<?>, Model.Params, AnnotationStatistics<String>> test(CollectionReader reader, File directory) throws Exception {
        String goldViewName = "GoldView";
        AggregateBuilder preprocess = new AggregateBuilder();
        preprocess.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", "TimeMLView"}), new String[0]);
        preprocess.add(UriToDocumentTextAnnotator.getDescription(), new String[]{"_InitialView", "TimeMLView"});
        preprocess.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", goldViewName}), new String[0]);
        preprocess.add(TimeMlGoldAnnotator.getDescription(), new String[]{"_InitialView", goldViewName});
        if (this.inferredTLinksDirectories != null) {
            preprocess.add(AnalysisEngineFactory.createEngineDescription(UseInferredTlinks.class, (Object[])new Object[]{"InferredTLinksDirectories", this.inferredTLinksDirectories}), new String[]{"_InitialView", goldViewName});
        }
        if (this.useVerbClauseTlinks) {
            preprocess.add(PlainTextTlinkGoldAnnotator.getDescription(), new String[]{"_InitialView", goldViewName});
        }
        preprocess.add(AnalysisEngineFactory.createEngineDescription(FixTimeML.class, (Object[])new Object[0]), new String[]{"_InitialView", goldViewName});
        preprocess.add(AnalysisEngineFactory.createEngineDescription(CopyTextAndDocumentCreationTime.class, (Object[])new Object[]{"SourceView", goldViewName}), new String[0]);
        if (this.relationsOnly) {
            preprocess.add(AnalysisEngineFactory.createEngineDescription(CopyEventsAndTimes.class, (Object[])new Object[]{"SourceView", goldViewName}), new String[0]);
        }
        preprocess.add(AnalysisEngineFactory.createEngineDescription(SentenceAnnotator.class, (Object[])new Object[]{"sentenceModelPath", "/models/en-sent.bin", "windowClassNames", new Class[]{Text.class}}), new String[0]);
        preprocess.add(TokenAnnotator.getDescription(), new String[0]);
        preprocess.add(PosTaggerAnnotator.getDescription(), new String[0]);
        preprocess.add(DefaultSnowballStemmer.getDescription((String)"English"), new String[0]);
        preprocess.add(ParserAnnotator.getDescription(), new String[0]);
        AnalysisEngine preprocessEngine = preprocess.createAggregate();
        AggregateBuilder postprocess = new AggregateBuilder();
        postprocess.add(AnalysisEngineFactory.createEngineDescription(ShrinkTimesContainingEvents.class, (Object[])new Object[0]), new String[0]);
        postprocess.add(AnalysisEngineFactory.createEngineDescription(SetTemporalLinkIDs.class, (Object[])new Object[0]), new String[0]);
        postprocess.add(TempEval2013Writer.getDescription((File)new File(this.baseDirectory, "timeml")), new String[0]);
        AnalysisEngine postprocessEngine = postprocess.createAggregate();
        ImmutableTable.Builder enginesBuilder = ImmutableTable.builder();
        ImmutableTable.Builder statsBuilder = ImmutableTable.builder();
        for (Model model : this.models.keySet()) {
            for (Model.Params params : this.models.get((Object)model)) {
                AnalysisEngineDescription desc = model.getAnnotatorDescription(directory, params);
                enginesBuilder.put((Object)model, (Object)params, (Object)AnalysisEngineFactory.createEngine((AnalysisEngineDescription)desc, (Object[])new Object[0]));
                statsBuilder.put((Object)model, (Object)params, (Object)new AnnotationStatistics());
            }
        }
        ImmutableTable engines = enginesBuilder.build();
        ImmutableTable stats = statsBuilder.build();
        JCasIterator iter = new JCasIterator(reader, new AnalysisEngine[]{preprocessEngine});
        while (iter.hasNext()) {
            JCas jCas = iter.next();
            JCas goldView = jCas.getView(goldViewName);
            JCas systemView = jCas.getView("_InitialView");
            for (Model model : engines.rowKeySet()) {
                Map annotations = model.removeModelAnnotations(jCas);
                for (Map.Entry entry : engines.row((Object)model).entrySet()) {
                    Model.Params params = (Model.Params)entry.getKey();
                    AnalysisEngine engine = (AnalysisEngine)entry.getValue();
                    model.removeModelAnnotations(jCas);
                    engine.process(jCas);
                    model.evaluate(goldView, systemView, (AnnotationStatistics<String>)((AnnotationStatistics)stats.get((Object)model, (Object)params)));
                }
                model.restoreModelAnnotations(jCas, annotations);
            }
            postprocessEngine.process(jCas);
        }
        return stats;
    }

    public static class UseInferredTlinks
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_INFERRED_TLINKS_DIRECTORIES = "InferredTLinksDirectories";
        @ConfigurationParameter(name="InferredTLinksDirectories", mandatory=true)
        private List<File> inferredTLinksDirectories;
        private Map<String, File> fileNameToFile;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            this.fileNameToFile = Maps.newHashMap();
            for (File dir : this.inferredTLinksDirectories) {
                for (File file : dir.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.endsWith(".tml")) continue;
                    String extension = String.format("[.]%s[.]tml$", dir.getName());
                    this.fileNameToFile.put(fileName.replaceAll(extension, ".tml"), file);
                }
            }
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            String fileName = new File(ViewUriUtil.getURI((JCas)jCas).getPath()).getName();
            File inferredTLinksFile = this.fileNameToFile.get(fileName);
            if (inferredTLinksFile == null) {
                this.getLogger().warn((Object)("No inferred TLINKs found for " + fileName));
            } else {
                Document xml;
                for (TemporalLink tlink : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, TemporalLink.class))) {
                    tlink.removeFromIndexes();
                }
                SAXBuilder builder = new SAXBuilder();
                try {
                    xml = builder.build(inferredTLinksFile);
                }
                catch (JDOMException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                HashMap idToAnchor = Maps.newHashMap();
                for (Anchor anchor : JCasUtil.select((JCas)jCas, Anchor.class)) {
                    idToAnchor.put(anchor.getId(), anchor);
                    if (!(anchor instanceof Event)) continue;
                    idToAnchor.put(((Event)anchor).getEventInstanceID(), anchor);
                }
                int offset = jCas.getDocumentText().length();
                for (Element linkElem : xml.getDescendants(Filters.element((String)"TLINK"))) {
                    String targetID;
                    Anchor target;
                    String targetTimeID;
                    String sourceID;
                    Anchor source;
                    String sourceTimeID;
                    String sourceEventID;
                    String relationType = linkElem.getAttributeValue("relType");
                    if (relationType == null) {
                        UseInferredTlinks.error(jCas, linkElem, "No relation type specified in %s");
                    }
                    if (!((sourceEventID = linkElem.getAttributeValue("eventInstanceID")) == null ^ (sourceTimeID = linkElem.getAttributeValue("timeID")) == null)) {
                        UseInferredTlinks.error(jCas, linkElem, "Expected exactly 1 source attribute, found %s");
                    }
                    if ((source = (Anchor)idToAnchor.get(sourceID = sourceEventID != null ? sourceEventID : sourceTimeID)) == null) {
                        this.getLogger().warn((Object)UseInferredTlinks.errorString(jCas, linkElem, "No annotation found for source of %s"));
                        continue;
                    }
                    String targetEventID = linkElem.getAttributeValue("relatedToEventInstance");
                    if (!(targetEventID == null ^ (targetTimeID = linkElem.getAttributeValue("relatedToTime")) == null)) {
                        UseInferredTlinks.error(jCas, linkElem, "Expected exactly 1 target attribute, found %s");
                    }
                    if ((target = (Anchor)idToAnchor.get(targetID = targetEventID != null ? targetEventID : targetTimeID)) == null) {
                        this.getLogger().warn((Object)UseInferredTlinks.errorString(jCas, linkElem, "No annotation found for target of %s"));
                        continue;
                    }
                    TemporalLink link = new TemporalLink(jCas, offset, offset);
                    link.setRelationType(relationType);
                    link.setSource(source);
                    link.setTarget(target);
                    link.addToIndexes();
                }
            }
        }

        private static String errorString(JCas jCas, Element element, String message) throws AnalysisEngineProcessException {
            URI uri = ViewUriUtil.getURI((JCas)jCas);
            String elemString = new XMLOutputter().outputString(element);
            return String.format("In %s: " + message, uri, elemString);
        }

        private static void error(JCas jCas, Element element, String message) throws AnalysisEngineProcessException {
            throw new IllegalArgumentException(UseInferredTlinks.errorString(jCas, element, message));
        }
    }

    public static class ShrinkTimesContainingEvents
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            String text = jCas.getDocumentText();
            for (Time time : JCasUtil.select((JCas)jCas, Time.class)) {
                int timeEnd;
                int timeBegin;
                List events = JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)time);
                if (events.isEmpty()) continue;
                int eventsBegin = ((Event)events.get(0)).getBegin();
                int eventsEnd = ((Event)events.get(events.size() - 1)).getEnd();
                if (time.getBegin() - eventsBegin > time.getEnd() - eventsEnd) {
                    timeBegin = time.getBegin();
                    for (timeEnd = eventsBegin - 1; timeEnd > timeBegin && Character.isWhitespace(text.charAt(timeEnd)); --timeEnd) {
                    }
                } else {
                    timeEnd = time.getEnd();
                    for (timeBegin = eventsEnd; timeBegin < timeEnd && Character.isWhitespace(text.charAt(timeBegin)); ++timeBegin) {
                    }
                }
                String oldText = time.getCoveredText();
                time.setBegin(timeBegin);
                time.setEnd(timeEnd);
                String newText = time.getCoveredText();
                this.getLogger().warn((Object)String.format("shrinking \"%s\" to \"%s\"", oldText, newText));
            }
        }
    }

    public static class SetTemporalLinkIDs
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            int index = 1;
            for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
                tlink.setId(String.format("l%d", index));
                ++index;
            }
        }
    }

    public static class FixTimeML
    extends JCasAnnotator_ImplBase {
        private static Set<String> IS_SIMULTANEOUS = Sets.newHashSet((Object[])new String[]{"DURING", "DURING_INV", "IDENTITY"});

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (Event event : JCasUtil.select((JCas)jCas, Event.class)) {
                if (event.getAspect() == null) {
                    event.setAspect("NONE");
                }
                if (event.getModality() == null) {
                    event.setModality("none");
                }
                String modality = event.getModality();
                event.setModality(modality.toLowerCase().replaceAll("_", " ").replaceAll("^'d$", "would"));
                if (event.getPolarity() == null) {
                    event.setPolarity("POS");
                }
                if (event.getTense() != null) continue;
                event.setTense("NONE");
            }
            for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
                if (!IS_SIMULTANEOUS.contains(tlink.getRelationType())) continue;
                tlink.setRelationType("SIMULTANEOUS");
            }
            for (TemporalLink tlink : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, TemporalLink.class))) {
                if (!"OVERLAP".equals(tlink.getRelationType())) continue;
                tlink.removeFromIndexes();
            }
        }
    }

    public static class CopyEventsAndTimes
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_SOURCE_VIEW = "SourceView";
        @ConfigurationParameter(name="SourceView")
        private String sourceViewName;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas sourceView;
            try {
                sourceView = jCas.getView(this.sourceViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            CasCopier copier = new CasCopier(sourceView.getCas(), jCas.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
            for (Event sourceEvent : JCasUtil.select((JCas)sourceView, Event.class)) {
                Event event = (Event)copier.copyFs((FeatureStructure)sourceEvent);
                event.setFeatureValue(sofaFeature, (FeatureStructure)jCas.getSofa());
                if (event.getEventInstanceID() == null) {
                    event.setEventInstanceID(event.getId().replaceAll("^e", "ei"));
                }
                event.addToIndexes();
            }
            for (Time sourceTime : JCasUtil.select((JCas)sourceView, Time.class)) {
                if (sourceTime instanceof DocumentCreationTime) continue;
                Time time = (Time)copier.copyFs((FeatureStructure)sourceTime);
                time.setFeatureValue(sofaFeature, (FeatureStructure)jCas.getSofa());
                time.addToIndexes();
            }
        }
    }

    public static class CopyTextAndDocumentCreationTime
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_SOURCE_VIEW = "SourceView";
        @ConfigurationParameter(name="SourceView")
        private String sourceViewName;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas sourceView;
            try {
                sourceView = jCas.getView(this.sourceViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            CasCopier copier = new CasCopier(sourceView.getCas(), jCas.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
            jCas.setDocumentText(sourceView.getDocumentText());
            Text sourceText = (Text)JCasUtil.selectSingle((JCas)sourceView, Text.class);
            Text text = (Text)copier.copyFs((FeatureStructure)sourceText);
            text.setFeatureValue(sofaFeature, (FeatureStructure)jCas.getSofa());
            text.addToIndexes();
            DocumentCreationTime sourceTime = (DocumentCreationTime)JCasUtil.selectSingle((JCas)sourceView, DocumentCreationTime.class);
            DocumentCreationTime time = (DocumentCreationTime)copier.copyFs((FeatureStructure)sourceTime);
            time.setFeatureValue(sofaFeature, (FeatureStructure)jCas.getSofa());
            time.addToIndexes();
        }
    }

    static interface Options {
        @Option(longName={"train-dirs"})
        public List<File> getTrainDirectories();

        @Option(longName={"test-dirs"}, defaultToNull=true)
        public List<File> getTestDirectories();

        @Option(longName={"inferred-tlinks"}, defaultToNull=true)
        public List<File> getInferredTLinksDirectories();

        @Option(longName={"verb-clause-tlinks"})
        public boolean getVerbClauseTLinks();

        @Option(longName={"relations-only"})
        public boolean getRelationsOnly();

        @Option(longName={"tune"}, defaultToNull=true)
        public String getNameOfModelToTune();

        @Option(longName={"train-only"})
        public boolean getTrainOnly();
    }
}

