/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.tab;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.component.animation.AnimationBehavior;
import org.icefaces.component.animation.ClientBehaviorContextImpl;
import org.icefaces.component.tab.TabPane;
import org.icefaces.component.tab.TabSet;
import org.icefaces.component.tab.Tabs;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.tab.TabSet")
public class TabSetRenderer
extends Renderer {
    private static String YUI_TABSET_INDEX = "yti";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(YUI_TABSET_INDEX)) {
            String[] info = String.valueOf(requestParameterMap.get(YUI_TABSET_INDEX)).split("=");
            String clientId = uiComponent.getClientId(facesContext);
            TabSet tabSet = (TabSet)uiComponent;
            if (clientId.equals(info[0])) {
                try {
                    Integer index = new Integer(info[1]);
                    if (tabSet.getSelectedIndex() != index.intValue()) {
                        uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, (Object)new Integer(tabSet.getSelectedIndex()), (Object)index));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        Utils.iterateEffects(new AnimationBehavior.Iterator(uiComponent){

            public void next(String name, AnimationBehavior effectBehavior) {
                effectBehavior.decode(FacesContext.getCurrentInstance(), this.getUIComponent());
            }
        });
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        TabSet tabSet = (TabSet)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        String style = tabSet.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        TabSet tabSet = (TabSet)uiComponent;
        boolean isBottom = "bottom".equals(tabSet.getOrientation());
        if (isBottom) {
            writer.startElement("div", uiComponent);
            writer.writeAttribute("tabindex", (Object)0, "tabindex");
            writer.writeAttribute("id", (Object)(clientId + "cnt"), "id");
            writer.writeAttribute("class", (Object)"yui-content", "class");
            this.renderTab(facesContext, uiComponent, false);
            writer.endElement("div");
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("class", (Object)"yui-nav", "class");
            if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
                writer.writeAttribute("role", (Object)"tablist", "role");
            }
            this.renderTab(facesContext, uiComponent, true);
            writer.endElement("ul");
        } else {
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("class", (Object)"yui-nav", "class");
            if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
                writer.writeAttribute("role", (Object)"tablist", "role");
            }
            this.renderTab(facesContext, uiComponent, true);
            writer.endElement("ul");
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "cnt"), "id");
            writer.writeAttribute("class", (Object)"yui-content", "class");
            this.renderTab(facesContext, uiComponent, false);
            writer.endElement("div");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        final TabSet tabSet = (TabSet)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        String styleClass = "yui-navset yui-navset-top ";
        String orientation = tabSet.getOrientation();
        if ("left".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-left ";
        } else if ("right".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-right ";
        } else if ("bottom".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-bottom ";
        }
        Object userDefinedClass = tabSet.getAttributes().get("styleClass");
        if (userDefinedClass != null) {
            styleClass = styleClass + userDefinedClass.toString();
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        boolean isClientSide = tabSet.isClientSide();
        boolean singleSubmit = tabSet.isSingleSubmit();
        int selectedIndex = tabSet.getSelectedIndex();
        if (selectedIndex >= this.getRenderedChildCount((UIComponent)tabSet)) {
            selectedIndex = 0;
        }
        StringBuilder call = new StringBuilder();
        call.append("ice.component.tabset.updateProperties('").append(clientId).append("', ").append(JSONBuilder.create().beginMap().entry("orientation", orientation).endMap().toString()).append(", ").append(JSONBuilder.create().beginMap().entry("isSingleSubmit", singleSubmit).entry("isClientSide", isClientSide).entry("aria", EnvUtils.isAriaEnabled((FacesContext)facesContext)).entry("selectedIndex", selectedIndex).endMap().toString()).append(");");
        if (isClientSide) {
            ScriptWriter.insertScript(facesContext, uiComponent, call.toString());
        } else {
            writer.writeAttribute("onmouseover", (Object)call.toString(), "onmouseover");
        }
        final StringBuilder effect = new StringBuilder();
        Utils.iterateEffects(new AnimationBehavior.Iterator(uiComponent){

            public void next(String event, AnimationBehavior effectBehavior) {
                effectBehavior.encodeBegin(FacesContext.getCurrentInstance(), (UIComponent)tabSet);
                effect.append(effectBehavior.getScript(new ClientBehaviorContextImpl(this.getUIComponent(), "transition"), false));
            }
        });
        if (effect.toString().length() > 0) {
            ScriptWriter.insertScript(facesContext, uiComponent, effect.toString());
        }
        writer.endElement("div");
    }

    private void renderTabNav(FacesContext facesContext, TabSet tabSet, UIComponent tab, int index) throws IOException {
        String clientId = tab.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("li", tab);
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"presentation", "role");
        }
        writer.writeAttribute("id", (Object)(clientId + "li" + index), "id");
        UIComponent labelFacet = ((TabPane)tab).getLabelFacet();
        if (!tabSet.isClientSide() && tabSet.getSelectedIndex() == index) {
            writer.writeAttribute("class", (Object)"selected", "class");
        }
        if (tabSet.isDisabled() || ((TabPane)tab).isDisabled()) {
            writer.writeAttribute("class", (Object)"disabled", "class");
        }
        writer.startElement("div", tab);
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"tab", "role");
        }
        if (!tabSet.isClientSide()) {
            writer.writeAttribute("onfocus", (Object)"this.parentNode.parentNode.parentNode.onmouseover()", "onfocus");
        }
        writer.writeAttribute("id", (Object)(clientId + "tab" + index), "id");
        writer.writeAttribute("tabindex", (Object)"0", "tabindex");
        writer.writeAttribute("class", (Object)"yui-navdiv", "class");
        writer.startElement("em", tab);
        writer.writeAttribute("id", (Object)(clientId + "Lbl"), "id");
        writer.writeAttribute("onclick", (Object)"if(ice.component_util.isEventSourceInputElement(event)) event.cancelBubble = true;", "onclick");
        if (labelFacet != null) {
            Utils.renderChild(facesContext, ((TabPane)tab).getLabelFacet());
        } else {
            writer.write(String.valueOf(tab.getAttributes().get("label")));
        }
        writer.endElement("em");
        writer.endElement("div");
        writer.startElement("a", tab);
        writer.writeAttribute("style", (Object)"display:none;", "style");
        writer.endElement("a");
        writer.endElement("li");
    }

    private void renderTabBody(FacesContext facesContext, TabSet tabSet, UIComponent tab, int index) throws IOException {
        boolean isClientSide;
        String clientId = tab.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", tab);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("tabindex", (Object)0, "tabindex");
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"tabpanel", "role");
        }
        if (isClientSide = tabSet.isClientSide()) {
            Utils.renderChild(facesContext, tab);
        } else if (tabSet.getSelectedIndex() == index) {
            final StringBuilder style = new StringBuilder();
            Utils.iterateEffects(new AnimationBehavior.Iterator((UIComponent)tabSet){

                public void next(String name, AnimationBehavior effectBehavior) {
                    if (effectBehavior.getStyle() != null) {
                        style.append(effectBehavior.getStyle());
                        style.append(";");
                    }
                }
            });
            if (style.toString().length() > 0) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            Utils.renderChild(facesContext, tab);
        } else {
            writer.writeAttribute("class", (Object)"yui-hidden iceOutConStatActv", "class");
            writer.write("&#160;");
        }
        writer.endElement("div");
    }

    private void renderTab(FacesContext facesContext, UIComponent uiComponent, boolean isLabel) throws IOException {
        TabSet tabSet = (TabSet)uiComponent;
        Iterator children = tabSet.getChildren().iterator();
        int index = -1;
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (child instanceof TabPane) {
                if (!child.isRendered()) continue;
                ++index;
                if (isLabel) {
                    this.renderTabNav(facesContext, tabSet, child, index);
                    continue;
                }
                this.renderTabBody(facesContext, tabSet, child, index);
                continue;
            }
            if (!(child instanceof Tabs)) continue;
            Tabs uiList = (Tabs)child;
            int rowIndex = uiList.getFirst();
            int numberOfRowsToDisplay = uiList.getRows();
            for (int countOfRowsDisplayed = 0; numberOfRowsToDisplay == 0 || numberOfRowsToDisplay > 0 && countOfRowsDisplayed < numberOfRowsToDisplay; ++countOfRowsDisplayed) {
                uiList.setRowIndex(rowIndex);
                if (!uiList.isRowAvailable()) break;
                if (uiList.getChildCount() > 0) {
                    for (UIComponent nextChild : uiList.getChildren()) {
                        if (!nextChild.isRendered()) continue;
                        ++index;
                        if (isLabel) {
                            this.renderTabNav(facesContext, tabSet, nextChild, index);
                            continue;
                        }
                        this.renderTabBody(facesContext, tabSet, nextChild, index);
                    }
                }
                ++rowIndex;
            }
            uiList.setRowIndex(-1);
        }
    }

    private int getRenderedChildCount(UIComponent uiComponent) {
        int count = 0;
        for (UIComponent component : uiComponent.getChildren()) {
            if (!(component instanceof TabPane) || !component.isRendered()) continue;
            ++count;
        }
        return count;
    }
}

