/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Annotation Remover", description="Removes annotations of a given type from the JCas.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN})
public class FilterAnnotator
extends JCasAnnotator_ImplBase {
    private static int DISORDER_ANNOTATIONS = 2;
    private int retainAnnType = EntityMention.type;
    private int retainAttrTypeId = DISORDER_ANNOTATIONS;
    private List<Annotation> removeList;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        this.removeList = new ArrayList<Annotation>();
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.removeList.clear();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (Annotation ann : indexes.getAnnotationIndex(this.retainAnnType)) {
            if (this.isValid(ann)) continue;
            this.removeList.add(ann);
        }
        for (int i = 0; i < this.removeList.size(); ++i) {
            this.removeList.get(i).removeFromIndexes();
        }
    }

    private boolean isValid(Annotation ann) {
        return ((IdentifiedAnnotation)ann).getTypeID() == this.retainAttrTypeId;
    }
}

