/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

final class CssWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"CssWriter");

    private CssWriter() {
    }

    static boolean writeCssFile(String filePath) {
        File outputFile = new File(filePath);
        if (outputFile.exists()) {
            return false;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(CssWriter.setBody());
            writer.write(CssWriter.setUnderline("affirmed", "green", "solid", "0.2"));
            writer.write(CssWriter.setUnderline("uncertain", "gold", "dotted", "0.2"));
            writer.write(CssWriter.setUnderline("negated", "red", "dashed", "0.2"));
            writer.write(CssWriter.setUnderline("uncertainnegated", "orange", "dashed", "0.2"));
            writer.write(CssWriter.getToolTipCss());
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write css file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
        return true;
    }

    private static String setBody() {
        return "\nbody {\n  margin: 20px;\n}\n\ndiv {\n  margin-bottom: 0.4em;\n}\n";
    }

    private static String setUnderline(String className, String color, String dashType, String size) {
        return "\n." + className + " {\n" + "  position: relative;\n" + "  display: inline-block " + color + ";\n" + "  border-bottom: " + size + "em " + dashType + " " + color + ";\n" + "}\n";
    }

    private static String setColor(String className, String color) {
        return "\n." + className + "::first-letter {\n" + "  font-weight: bold;\n" + "}\n";
    }

    private static String setHighlight(String idName, String color) {
        return "#" + idName + "{\n  background-color: " + color + ";\n}\n";
    }

    private static String getToolTipCss() {
        return "\n[data-tooltip] {\n  position: relative;\n  z-index: 2;\n  cursor: pointer;\n}\n[data-tooltip]::before,\n[data-tooltip]::after {\n  visibility: hidden;\n  -ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\n  filter: progid: DXImageTransform.Microsoft.Alpha(Opacity=0);\n  opacity: 0;\n  pointer-events: none;\n}\n[data-tooltip]::before {\n  position: absolute;\n  bottom: 50%;\n  left: 50%;\n  margin-bottom: 5px;\n  padding: 7px;\n  -webkit-border-radius: 3px;\n  -moz-border-radius: 3px;\n  border-radius: 3px;\n  background-color: #000;\n  background-color: hsla(0, 0%, 20%, 0.9);\n  color: #fff;\n  content: attr(data-tooltip);\n  text-align: center;\n  font-size: 14px;\n  line-height: 1.2;\n}\n[data-tooltip]:hover::before,\n[data-tooltip]:hover::after {\n  visibility: visible;\n  -ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\n  filter: progid: DXImageTransform.Microsoft.Alpha(Opacity=100);\n  opacity: 1;\n}\n";
    }
}

