/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.row;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.ctakes.core.cc.pretty.cell.ItemCell;
import org.apache.ctakes.core.cc.pretty.row.ItemRow;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;

public final class DefaultItemRow
implements ItemRow {
    private static final char END_CHAR = '|';
    private static final char FILL_CHAR = '=';
    private final Collection<ItemCell> _itemCells = new HashSet<ItemCell>();
    private int _rowHeight = 0;

    @Override
    public boolean addItemCell(ItemCell itemCell) {
        TextSpan textSpan = itemCell.getTextSpan();
        for (ItemCell extantItemCell : this._itemCells) {
            if (!extantItemCell.getTextSpan().overlaps(textSpan)) continue;
            return false;
        }
        this._itemCells.add(itemCell);
        this._rowHeight = Math.max(this._rowHeight, itemCell.getHeight());
        return true;
    }

    @Override
    public int getHeight() {
        return this._rowHeight;
    }

    @Override
    public Collection<ItemCell> getItemCells() {
        return this._itemCells;
    }

    @Override
    public String getTextLine(int lineIndex, int rowWidth, Map<Integer, Integer> offsetAdjustedMap) {
        char[] chars = new char[rowWidth];
        Arrays.fill(chars, ' ');
        StringBuilder sb = new StringBuilder(rowWidth);
        sb.append(chars);
        for (ItemCell itemCell : this._itemCells) {
            int begin = offsetAdjustedMap.get(itemCell.getTextSpan().getBegin());
            int end = offsetAdjustedMap.get(itemCell.getTextSpan().getEnd());
            int width = end - begin;
            String annotationText = itemCell.getLineText(lineIndex);
            if (annotationText.equals("ENTITY_FILL")) {
                char[] fill_chars = new char[width];
                Arrays.fill(fill_chars, '=');
                fill_chars[0] = 124;
                fill_chars[fill_chars.length - 1] = 124;
                sb.replace(begin, begin + width, new String(fill_chars));
                continue;
            }
            int paddedOffset = DefaultItemRow.getPaddedOffset(annotationText, width);
            sb.replace(begin + paddedOffset, begin + paddedOffset + annotationText.length(), annotationText);
        }
        return sb.toString();
    }

    private static int getPaddedOffset(CharSequence text, int width) {
        int textWidth = text.length();
        if (textWidth == width) {
            return 0;
        }
        return (width - textWidth) / 2;
    }
}

