/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.textspan;

import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;
import org.apache.uima.cas.text.AnnotationFS;

@Immutable
public final class DefaultTextSpan
implements TextSpan {
    private final int _begin;
    private final int _end;

    public DefaultTextSpan(AnnotationFS annotation, int sentenceOffset) {
        this(annotation.getBegin() - sentenceOffset, annotation.getEnd() - sentenceOffset);
    }

    public DefaultTextSpan(int begin, int end) {
        this._begin = begin;
        this._end = end;
    }

    @Override
    public int getBegin() {
        return this._begin;
    }

    @Override
    public int getEnd() {
        return this._end;
    }

    @Override
    public int getWidth() {
        return this._end - this._begin;
    }

    @Override
    public boolean overlaps(TextSpan textSpan) {
        return textSpan.getEnd() - 1 >= this._begin && textSpan.getBegin() <= this._end - 1;
    }

    public String toString() {
        return this.getBegin() + "," + this.getEnd();
    }

    public boolean equals(Object other) {
        return other instanceof TextSpan && ((TextSpan)other).getBegin() == this._begin && ((TextSpan)other).getEnd() == this._end;
    }

    public int hashCode() {
        return 1000 * this._end + this._begin;
    }
}

