/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.collection;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionCreator;
import org.apache.ctakes.core.util.collection.CollectionCreatorFactory;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.DefaultCollectionMap;

public final class EnumSetMap<K extends Enum<K>, V>
implements CollectionMap<K, V, Set<V>> {
    private final CollectionMap<K, V, Set<V>> _delegate;

    public EnumSetMap(Class<K> enumType) {
        EnumMap enumMap = new EnumMap(enumType);
        CollectionCreator creator = CollectionCreatorFactory.createSetCreator();
        this._delegate = new DefaultCollectionMap(enumMap, creator);
    }

    @Override
    public Iterator<Map.Entry<K, Set<V>>> iterator() {
        return this._delegate.iterator();
    }

    @Override
    public Collection<Set<V>> getAllCollections() {
        return new HashSet<Set<V>>(this._delegate.values());
    }

    @Override
    public Set<V> getCollection(K key) {
        return this._delegate.getCollection(key);
    }

    @Override
    public Set<V> getOrCreateCollection(K key) {
        return this._delegate.getOrCreateCollection(key);
    }

    @Override
    public boolean containsValue(K key, V value) {
        return this._delegate.containsValue(key, value);
    }

    @Override
    public boolean placeValue(K key, V value) {
        return this._delegate.placeValue(key, value);
    }

    @Override
    public boolean placeMap(Map<K, V> map) {
        return this._delegate.placeMap(map);
    }

    @Override
    public void removeValue(K key, V value) {
        this._delegate.removeValue(key, value);
    }

    @Override
    public <C extends Collection<V>> int addAllValues(K key, C collection) {
        return this._delegate.addAllValues(key, collection);
    }

    @Override
    public void clearCollection(K key) {
        this._delegate.clearCollection(key);
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._delegate.containsValue(value);
    }

    @Override
    public Set<V> get(Object key) {
        return (Set)this._delegate.get(key);
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this._delegate.put(key, value);
    }

    @Override
    public Set<V> remove(Object key) {
        return (Set)this._delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> map) {
        this._delegate.putAll(map);
    }

    @Override
    public void clear() {
        this._delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._delegate.keySet();
    }

    @Override
    public Collection<Set<V>> values() {
        return this._delegate.values();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this._delegate.entrySet();
    }

    @Override
    public Map<K, Set<V>> toSimpleMap() {
        return this._delegate;
    }
}

