/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.DegreeOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.baselines.Utils;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Degree of Annotator 4", description="Annotates Degree Of relations between two entities whenever they are enclosed within the same noun phrase.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.DEGREE_RELATION})
public class Baseline4DegreeOfRelationExtractorAnnotator
extends DegreeOfRelationExtractorAnnotator {
    @Override
    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        Iterable pairs = super.getCandidateRelationArgumentPairs(identifiedAnnotationView, sentence);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> result = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        block0: for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
            if (!Utils.validateDegreeOfArgumentTypes(pair)) continue;
            for (TreebankNode nounPhrase : Utils.getNounPhrases(identifiedAnnotationView, (Sentence)sentence)) {
                if (!Utils.isEnclosed(pair, nounPhrase)) continue;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                result.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(arg1, arg2));
                System.out.println("NP: " + nounPhrase.getCoveredText() + ", " + nounPhrase.getBegin() + ", " + nounPhrase.getEnd());
                System.out.println("arg1: " + arg1.getCoveredText() + ", " + arg1.getBegin() + ", " + arg1.getEnd());
                System.out.println("arg2: " + arg2.getCoveredText() + ", " + arg2.getBegin() + ", " + arg2.getEnd());
                System.out.println();
                continue block0;
            }
        }
        return result;
    }
}

