/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class PhraseChunkingExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    List<TerminalTreebankNode> extractPhraseHeadByTreenode(JCas jCas, List<TreebankNode> treenodesList) {
        ArrayList<TerminalTreebankNode> rTNodeList = new ArrayList<TerminalTreebankNode>();
        block0: for (TreebankNode tb : treenodesList) {
            if (tb.getHeadIndex() <= 0 || !tb.getNodeType().endsWith("P") || tb.getNodeType().equals("NNP")) continue;
            int headIndex = tb.getHeadIndex();
            for (TerminalTreebankNode ttb : JCasUtil.selectCovered((JCas)jCas, TerminalTreebankNode.class, (AnnotationFS)tb)) {
                if (ttb.getIndex() != headIndex) continue;
                PhraseChunkingExtractor.addPhraseHead(rTNodeList, ttb);
                continue block0;
            }
        }
        return rTNodeList;
    }

    private static void addPhraseHead(List<TerminalTreebankNode> headList, TerminalTreebankNode newHead) {
        int insertPos = 0;
        for (int i = headList.size(); i > 0; --i) {
            if (newHead.getEnd() > headList.get(i - 1).getEnd()) {
                insertPos = i;
                break;
            }
            if (newHead.getEnd() != headList.get(i - 1).getEnd()) continue;
            insertPos = -1;
            break;
        }
        if (insertPos >= 0) {
            headList.add(insertPos, newHead);
        }
    }

    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        int i;
        ArrayList<Feature> features = new ArrayList<Feature>();
        List<TerminalTreebankNode> headList = this.extractPhraseHeadByTreenode(jCas, JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (int)arg1.getEnd(), (int)arg2.getBegin()));
        if (headList.size() > 0) {
            features.add(new Feature("PhraseChunk_Between_FirstHead", (Object)headList.get(0).getNodeValue()));
            features.add(new Feature("PhraseChunk_Between_LastHead", (Object)headList.get(headList.size() - 1).getNodeValue()));
            if (headList.size() >= 2) {
                String inBetweenValue = "";
                for (i = 1; i < headList.size() - 1; ++i) {
                    if (i > 1) {
                        inBetweenValue = inBetweenValue + "_";
                    }
                    inBetweenValue = inBetweenValue + headList.get(i).getNodeValue();
                }
                features.add(new Feature("PhraseChunk_Between_BetweenHeads", (Object)inBetweenValue));
            }
        }
        headList = this.extractPhraseHeadByTreenode(jCas, JCasUtil.selectPreceding((JCas)jCas, TreebankNode.class, (AnnotationFS)arg1, (int)20));
        boolean isFirst = false;
        for (i = headList.size() - 1; i >= 0; --i) {
            if (headList.get(i).getEnd() >= arg1.getBegin()) continue;
            if (!isFirst) {
                features.add(new Feature("PhraseChunk_Before_FirstHead", (Object)headList.get(i).getNodeValue()));
                isFirst = true;
                continue;
            }
            features.add(new Feature("PhraseChunk_Before_SecondHead", (Object)headList.get(i).getNodeValue()));
            break;
        }
        headList = this.extractPhraseHeadByTreenode(jCas, JCasUtil.selectFollowing((JCas)jCas, TreebankNode.class, (AnnotationFS)arg2, (int)20));
        isFirst = false;
        for (i = 0; i < headList.size(); ++i) {
            if (headList.get(i).getBegin() <= arg2.getEnd()) continue;
            if (!isFirst) {
                features.add(new Feature("PhraseChunk_After_FirstHead", (Object)headList.get(i).getNodeValue()));
                isFirst = true;
                continue;
            }
            features.add(new Feature("PhraseChunk_After_SecondHead", (Object)headList.get(i).getNodeValue()));
            break;
        }
        return features;
    }
}

