/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import edu.mit.jwi.IDictionary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.WordNetUtils;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class WordNetFeatureExtractor {
    public static List<Feature> extract(JCas jCas, IdentifiedAnnotation identifiedAnnotation, IDictionary iDictionary) {
        String pos;
        ArrayList<Feature> features = new ArrayList<Feature>();
        List baseTokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (int)identifiedAnnotation.getBegin(), (int)identifiedAnnotation.getEnd());
        if (baseTokens.size() < 1) {
            return features;
        }
        String token = ((BaseToken)baseTokens.get(0)).getCoveredText().toLowerCase();
        List<String> stems = WordNetUtils.getStems(token, pos = ((BaseToken)baseTokens.get(0)).getPartOfSpeech(), iDictionary);
        if (stems.size() > 0) {
            HashSet<String> hypernyms = WordNetUtils.getHypernyms(iDictionary, stems.get(0), pos, true);
            for (String hypernym : hypernyms) {
                features.add(new Feature("wn_hypernym", (Object)hypernym));
            }
        }
        return features;
    }
}

