/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.pipelines;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class SelectiveRelationAnnotationViewer {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        List<File> trainFiles = Arrays.asList(options.inputDirectory.listFiles());
        CollectionReader collectionReader = SelectiveRelationAnnotationViewer.getCollectionReader(trainFiles);
        AnalysisEngine relationExtractorPrinter = AnalysisEngineFactory.createEngine(RelationExtractorPrinter.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{relationExtractorPrinter});
    }

    private static CollectionReader getCollectionReader(List<File> items) throws Exception {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static HashSet<String> getOntologyConceptCodes(IdentifiedAnnotation identifiedAnnotation) {
        HashSet<String> codes = new HashSet<String>();
        FSArray fsArray = identifiedAnnotation.getOntologyConceptArr();
        if (fsArray == null) {
            return codes;
        }
        for (FeatureStructure featureStructure : fsArray.toArray()) {
            OntologyConcept ontologyConcept = (OntologyConcept)featureStructure;
            if (ontologyConcept instanceof UmlsConcept) {
                UmlsConcept umlsConcept = (UmlsConcept)ontologyConcept;
                String code = umlsConcept.getCui();
                codes.add(code);
                continue;
            }
            String code = ontologyConcept.getCodingScheme() + ontologyConcept.getCode();
            codes.add(code);
        }
        return codes;
    }

    public static Set<String> getCustomizedDictionary(String path) {
        HashSet<String> cuis = new HashSet<String>();
        File file = new File(path);
        Scanner scan = null;
        try {
            scan = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            System.err.println("couldn't open file: " + path);
            return cuis;
        }
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            cuis.add(line);
        }
        return cuis;
    }

    public static class RelationExtractorPrinter
    extends JCasAnnotator_ImplBase {
        private String dictionaryPath = "cuis.txt";
        private Set<String> cuiDictionary;

        public void initialize(UimaContext aContext) throws ResourceInitializationException {
            super.initialize(aContext);
            this.cuiDictionary = SelectiveRelationAnnotationViewer.getCustomizedDictionary(this.dictionaryPath);
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)systemView, BinaryTextRelation.class)) {
                IdentifiedAnnotation entity2;
                IdentifiedAnnotation entity1;
                if (binaryTextRelation.getArg1().getRole().equals("Argument")) {
                    entity1 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
                    entity2 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
                } else {
                    entity1 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
                    entity2 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
                }
                String category = binaryTextRelation.getCategory();
                String arg1 = entity1.getCoveredText().toLowerCase();
                String arg2 = entity2.getCoveredText().toLowerCase();
                int type1 = entity1.getTypeID();
                int type2 = entity2.getTypeID();
                if (type1 != 6 || type1 == 6 && type2 == 6 || type2 == 2 && arg2.equals("to")) continue;
                HashSet<String> codes = SelectiveRelationAnnotationViewer.getOntologyConceptCodes(entity1);
                codes.retainAll(this.cuiDictionary);
                if (codes.size() <= 0) continue;
                System.out.format("%s(%s/%d, %s/%d)\n", category, arg1, type1, arg2, type2);
                List sentences = JCasUtil.selectCovering((JCas)systemView, Sentence.class, (int)entity1.getBegin(), (int)entity1.getEnd());
                System.out.println(((Sentence)sentences.get(0)).getCoveredText());
                System.out.println();
            }
        }
    }

    public static class Options {
        @Option(name="--input-dir", usage="specify the path to the directory containing the clinical notes to be processed", required=true)
        public File inputDirectory;
    }
}

