/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.CheckSpecialWordRelationExtractor;
import org.apache.ctakes.temporal.ae.feature.ConjunctionRelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.CoordinateFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.DependencyParseUtils;
import org.apache.ctakes.temporal.ae.feature.DependencyPathFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.EventArgumentPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.EventTimeRelationFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.NearbyVerbTenseRelationExtractor;
import org.apache.ctakes.temporal.ae.feature.NumberOfEventTimeBetweenCandidatesExtractor;
import org.apache.ctakes.temporal.ae.feature.NumberOfEventsInTheSameSentenceExtractor;
import org.apache.ctakes.temporal.ae.feature.OverlappedHeadFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.SRLRelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UnexpandedTokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;

@PipeBitInfo(name="E-E I2B2 TLinker", description="Creates Event - Event TLinks with I2B2 model.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventI2B2RelationAnnotator
extends RelationExtractorAnnotator {
    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory, double probabilityOfKeepingANegativeExample) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventI2B2RelationAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, "ProbabilityOfKeepingANegativeExample", Float.valueOf((float)probabilityOfKeepingANegativeExample)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventI2B2RelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventI2B2RelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new UnexpandedTokenFeaturesExtractor(), new PartOfSpeechFeaturesExtractor(), new EventArgumentPropertyExtractor(), new NumberOfEventTimeBetweenCandidatesExtractor(), new NearbyVerbTenseRelationExtractor(), new CheckSpecialWordRelationExtractor(), new UmlsFeatureExtractor(), new DependencyPathFeaturesExtractor(), new CoordinateFeaturesExtractor(), new OverlappedHeadFeaturesExtractor(), new SRLRelationFeaturesExtractor(), new NumberOfEventsInTheSameSentenceExtractor(), new ConjunctionRelationFeaturesExtractor(), new EventTimeRelationFeatureExtractor()});
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    protected List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
        ArrayList pairs = Lists.newArrayList();
        ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        int eventNum = events.size();
        for (int i = 0; i < eventNum - 1; ++i) {
            EventMention eventB = (EventMention)events.get(i);
            for (int j = i + 1; j < eventNum; ++j) {
                EventMention eventA = (EventMention)events.get(j);
                if (j - i != 1 && j - i != eventNum - 1 && !EventEventI2B2RelationAnnotator.ifDependent(jCas, eventA, eventB)) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB));
            }
        }
        return pairs;
    }

    private static boolean ifDependent(JCas jCas, EventMention ev1, EventMention ev2) {
        for (ConllDependencyNode firstNode : JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)ev1)) {
            String pos = firstNode.getPostag();
            if (!pos.startsWith("NN") && !pos.startsWith("VB")) continue;
            for (ConllDependencyNode nextNode : JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)ev2)) {
                ConllDependencyNode ancestor;
                pos = nextNode.getPostag();
                if (!pos.startsWith("NN") && !pos.startsWith("VB") || (ancestor = DependencyParseUtils.getCommonAncestor(firstNode, nextNode)) != firstNode && ancestor != nextNode) continue;
                return true;
            }
        }
        return false;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null && relation instanceof TemporalTextRelation) {
            category = relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null && relation instanceof TemporalTextRelation) {
                if (relation.getCategory().equals("OVERLAP")) {
                    category = relation.getCategory();
                } else if (relation.getCategory().equals("BEFORE")) {
                    category = "AFTER";
                } else if (relation.getCategory().equals("AFTER")) {
                    category = "BEFORE";
                }
            }
        }
        if (category == null && this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample) {
            category = "-NONE-";
        }
        return category;
    }
}

