/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ctakes.relationextractor.ae.features.DependencyPathFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.DependencyTreeFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.NamedEntityFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.PhraseChunkingExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.TokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

public abstract class TemporalRelationExtractorAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "-NONE-";
    public static final String PARAM_PROB_VIEW = "ProbView";
    @ConfigurationParameter(name="ProbView", mandatory=false)
    private String probViewname = null;
    public static final String PARAM_PROBABILITY_OF_KEEPING_A_NEGATIVE_EXAMPLE = "ProbabilityOfKeepingANegativeExample";
    public static Map<String, Integer> category_frequency = new LinkedHashMap<String, Integer>();
    public static final String MINMAX_EXTRACTOR_KEY = "MINMAXFeatures";
    @ConfigurationParameter(name="ProbabilityOfKeepingANegativeExample", mandatory=false, description="probability that a negative example should be retained for training")
    protected double probabilityOfKeepingANegativeExample = 1.0;
    protected Random coin = new Random(0L);
    private List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> featureExtractors = this.getFeatureExtractors();
    private Class<? extends Annotation> coveringClass = this.getCoveringClass();

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new TokenFeaturesExtractor(), new PartOfSpeechFeaturesExtractor(), new PhraseChunkingExtractor(), new NamedEntityFeaturesExtractor(), new DependencyTreeFeaturesExtractor(), new DependencyPathFeaturesExtractor()});
    }

    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return BinaryTextRelation.class;
    }

    protected abstract Class<? extends Annotation> getCoveringClass();

    protected abstract List<IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas var1, Annotation var2);

    static void allowClassifierModelOnClasspath(UimaContext context) {
        URL modelClasspathURL;
        String modelPathParam = "classifierJarPath";
        String modelPath = (String)context.getConfigParameterValue(modelPathParam);
        if (modelPath != null && (modelClasspathURL = TemporalRelationExtractorAnnotator.class.getResource(modelPath)) != null) {
            UimaContextAdmin contextAdmin = (UimaContextAdmin)context;
            ConfigurationManager manager = contextAdmin.getConfigurationManager();
            String qualifiedModelPathParam = contextAdmin.getQualifiedContextName() + modelPathParam;
            manager.setConfigParameterValue(qualifiedModelPathParam, (Object)modelClasspathURL.toString());
        }
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        TemporalRelationExtractorAnnotator.allowClassifierModelOnClasspath(context);
        super.initialize(context);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, this.getRelationClass())) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                }
                relationLookup.put(key, relation);
            }
        }
        for (Annotation coveringAnnotation : JCasUtil.select((JCas)jCas, this.coveringClass)) {
            List<IdentifiedAnnotationPair> candidatePairs = this.getCandidateRelationArgumentPairs(jCas, coveringAnnotation);
            for (IdentifiedAnnotationPair pair : candidatePairs) {
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> extractor : this.featureExtractors) {
                    List feats = extractor.extract(jCas, (Object)arg1, (Object)arg2);
                    if (feats == null) continue;
                    features.addAll(feats);
                }
                for (Feature feature : features) {
                    if (feature.getValue() != null) continue;
                    feature.setValue((Object)"NULL");
                    String message = String.format("Null value found in %s from %s", feature, features);
                    System.err.println(message);
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    if (category == null) continue;
                    if (category_frequency.containsKey(category)) {
                        category_frequency.put(category, category_frequency.get(category) + 1);
                    } else {
                        category_frequency.put(category, 1);
                    }
                    this.dataWriter.write(new Instance((Object)category, features));
                    continue;
                }
                String predictedCategory = this.classify(features);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory, 0.0);
            }
        }
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = relation != null ? relation.getCategory() : (this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample ? NO_RELATION_CATEGORY : null);
        return category;
    }

    protected String classify(List<Feature> features) throws CleartkProcessingException {
        return (String)this.classifier.classify(features);
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        BinaryTextRelation relation = new BinaryTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    public static class IdentifiedAnnotationPair {
        private final IdentifiedAnnotation arg1;
        private final IdentifiedAnnotation arg2;

        public IdentifiedAnnotationPair(IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public final IdentifiedAnnotation getArg1() {
            return this.arg1;
        }

        public final IdentifiedAnnotation getArg2() {
            return this.arg2;
        }
    }
}

