/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.util.WordTokenUtil;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class TemporalRelationRuleAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection sents = JCasUtil.select((JCas)jCas, Sentence.class);
        ArrayList sentList = Lists.newArrayList();
        sentList.addAll(sents);
        EventMention admission = null;
        int sentListLength = sentList.size();
        if (sentListLength >= 4) {
            for (int i = 0; i < 4; i += 2) {
                int nextTimeSize;
                Sentence currentSent = (Sentence)sentList.get(i);
                Sentence nextSent = (Sentence)sentList.get(i + 1);
                List currentEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)currentSent);
                List nextTimes = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)nextSent);
                int currentSize = currentEvents == null ? 0 : currentEvents.size();
                int n = nextTimeSize = nextTimes == null ? 0 : nextTimes.size();
                if (currentSize == 0 || nextTimeSize == 0) continue;
                EventMention currentEvent = (EventMention)currentEvents.get(0);
                TimeMention nextTime = (TimeMention)nextTimes.get(0);
                if (i == 0) {
                    admission = currentEvent;
                }
                TemporalRelationRuleAnnotator.createRelation(jCas, (IdentifiedAnnotation)currentEvent, (IdentifiedAnnotation)nextTime, "OVERLAP");
            }
        }
        Collection times = JCasUtil.select((JCas)jCas, TimeMention.class);
        ArrayList allTimes = Lists.newArrayList();
        allTimes.addAll(times);
        int timeNum = allTimes.size();
        if (timeNum > 2) {
            for (int i = 0; i < timeNum - 1; ++i) {
                TimeMention firstTime = (TimeMention)allTimes.get(i);
                for (int j = i + 1; j < timeNum; ++j) {
                    TimeMention secondTime = (TimeMention)allTimes.get(j);
                    if (!TemporalRelationRuleAnnotator.sameTime(jCas, firstTime, secondTime)) continue;
                    TemporalRelationRuleAnnotator.createRelation(jCas, (IdentifiedAnnotation)secondTime, (IdentifiedAnnotation)firstTime, "OVERLAP");
                }
            }
        }
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        ArrayList<EventMention> allEvents = JCasUtil.select((JCas)jCas, EventMention.class);
        ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
        for (EventMention event : allEvents) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        allEvents = realEvents;
        for (Sentence sent : sentences) {
            ArrayList<EventMention> currentEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sent);
            realEvents = new ArrayList();
            for (EventMention event : currentEvents) {
                if (!event.getClass().equals(EventMention.class)) continue;
                realEvents.add(event);
            }
            currentEvents = realEvents;
            for (EventMention event : currentEvents) {
                allEvents.remove(event);
                if (admission == null || event == admission || !event.getCoveredText().toLowerCase().startsWith("admitted")) continue;
                TemporalRelationRuleAnnotator.createRelation(jCas, (IdentifiedAnnotation)event, (IdentifiedAnnotation)admission, "OVERLAP");
            }
            for (EventMention arg1 : currentEvents) {
                for (EventMention arg2 : allEvents) {
                    if (!TemporalRelationRuleAnnotator.hasOverlapNNs(jCas, arg1, arg2)) continue;
                    TemporalRelationRuleAnnotator.createRelation(jCas, (IdentifiedAnnotation)arg2, (IdentifiedAnnotation)arg1, "OVERLAP");
                }
            }
        }
    }

    private static boolean sameTime(JCas jCas, TimeMention firstTime, TimeMention secondTime) {
        List currentTokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)firstTime);
        List nextTokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)secondTime);
        int tokenSize = currentTokens.size();
        if (tokenSize != nextTokens.size()) {
            return false;
        }
        for (int i = 0; i < tokenSize; ++i) {
            if (((BaseToken)currentTokens.get(i)).getCoveredText().equals(((BaseToken)nextTokens.get(i)).getCoveredText())) continue;
            return false;
        }
        return true;
    }

    private static void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String cagegory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(cagegory);
        relation.addToIndexes();
    }

    private static boolean hasOverlapNNs(JCas jCas, EventMention event1, EventMention event2) {
        List currentTokens = JCasUtil.selectCovered((JCas)jCas, WordToken.class, (AnnotationFS)event1);
        List nextTokens = JCasUtil.selectCovered((JCas)jCas, WordToken.class, (AnnotationFS)event2);
        if (currentTokens == null || currentTokens.isEmpty() || nextTokens == null || nextTokens.isEmpty()) {
            return false;
        }
        int NNSize1 = 0;
        int NNSize2 = 0;
        int matches = 0;
        for (WordToken t1 : currentTokens) {
            if (!t1.getPartOfSpeech().startsWith("NN") && !t1.getPartOfSpeech().startsWith("VB")) continue;
            ++NNSize1;
            for (WordToken t2 : nextTokens) {
                if (!t2.getPartOfSpeech().startsWith("NN") && !t2.getPartOfSpeech().startsWith("VB")) continue;
                ++NNSize2;
                if (!WordTokenUtil.getCanonicalForm((WordToken)t1).equals(WordTokenUtil.getCanonicalForm((WordToken)t2))) continue;
                ++matches;
            }
        }
        int NNSize = Math.min(NNSize1, NNSize2);
        if (NNSize == 0) {
            return false;
        }
        float matchRatio = (float)matches / (float)NNSize;
        return Float.compare(matchRatio, 1.0f) == 0;
    }
}

