/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.temporal.ae.feature.ClosestVerbExtractor;
import org.apache.ctakes.temporal.ae.feature.DateAndMeasurementExtractor;
import org.apache.ctakes.temporal.ae.feature.NearbyVerbTenseXExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeXExtractor;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

public class TimexDischargeTimeAnnotator
extends CleartkAnnotator<String> {
    private CleartkExtractor contextExtractor;
    private NearbyVerbTenseXExtractor verbTensePatternExtractor;
    private ClosestVerbExtractor closestVerbExtractor;
    private TimeXExtractor timeXExtractor;
    private DateAndMeasurementExtractor dateExtractor;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TimexDischargeTimeAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TimexDischargeTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TimexDischargeTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        CombinedExtractor1 baseExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.contextExtractor = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)baseExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Covered(), new CleartkExtractor.Following(3)});
        this.verbTensePatternExtractor = new NearbyVerbTenseXExtractor();
        this.closestVerbExtractor = new ClosestVerbExtractor();
        this.timeXExtractor = new TimeXExtractor();
        this.dateExtractor = new DateAndMeasurementExtractor();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Object dischargeTime = null;
        ArrayList courses = Lists.newArrayList();
        for (Object time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)40, (int)60)) {
            if (!time.getTimeClass().equals("DATE")) continue;
            dischargeTime = time;
            break;
        }
        if (dischargeTime != null) {
            Collection segments = JCasUtil.select((JCas)jCas, Segment.class);
            for (Segment seg : segments) {
                if (!seg.getId().equals("course") || JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)seg).size() <= 0) continue;
                courses.add(seg);
            }
            HashMap<List<Annotation>, TemporalTextRelation> dischargeTimeRelationLookup = new HashMap<List<Annotation>, TemporalTextRelation>();
            if (this.isTraining()) {
                for (TemporalTextRelation relation : JCasUtil.select((JCas)jCas, TemporalTextRelation.class)) {
                    Annotation arg1 = relation.getArg1().getArgument();
                    Annotation arg2 = relation.getArg2().getArgument();
                    if (arg1 instanceof TimeMention && arg2 instanceof TimeMention) {
                        if (arg1 != dischargeTime) continue;
                        dischargeTimeRelationLookup.put(Arrays.asList(arg1, arg2), relation);
                        continue;
                    }
                    if (!(arg1 instanceof TimeMention) || !(arg2 instanceof TimeMention) || arg2 != dischargeTime) continue;
                    dischargeTimeRelationLookup.put(Arrays.asList(arg1, arg2), relation);
                }
            }
            for (Segment course : courses) {
                for (TimeMention timeMention : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)course)) {
                    List features = this.contextExtractor.extract(jCas, (Annotation)timeMention);
                    features.addAll(this.verbTensePatternExtractor.extract(jCas, (Annotation)timeMention));
                    features.addAll(this.closestVerbExtractor.extract(jCas, (Annotation)timeMention));
                    features.addAll(this.timeXExtractor.extract(jCas, (Annotation)timeMention));
                    features.addAll(this.dateExtractor.extract(jCas, (Annotation)timeMention));
                    if (this.isTraining()) {
                        TemporalTextRelation relation = (TemporalTextRelation)dischargeTimeRelationLookup.get(Arrays.asList(timeMention, dischargeTime));
                        String category = null;
                        if (relation != null) {
                            category = relation.getCategory();
                        } else {
                            relation = (TemporalTextRelation)dischargeTimeRelationLookup.get(Arrays.asList(dischargeTime, timeMention));
                            if (relation != null) {
                                if (relation.getCategory().equals("OVERLAP")) {
                                    category = relation.getCategory();
                                } else if (relation.getCategory().equals("BEFORE")) {
                                    category = "AFTER";
                                } else if (relation.getCategory().equals("AFTER")) {
                                    category = "BEFORE";
                                }
                            }
                        }
                        if (category == null) continue;
                        this.dataWriter.write(new Instance((Object)category, (Collection)features));
                        continue;
                    }
                    String outcome = (String)this.classifier.classify(features);
                    if (outcome != null) {
                        RelationArgument relArg1 = new RelationArgument(jCas);
                        relArg1.setArgument((Annotation)timeMention);
                        relArg1.setRole("Argument");
                        relArg1.addToIndexes();
                        RelationArgument relArg2 = new RelationArgument(jCas);
                        relArg2.setArgument((Annotation)dischargeTime);
                        relArg2.setRole("Related_to");
                        relArg2.addToIndexes();
                        TemporalTextRelation relation = new TemporalTextRelation(jCas);
                        relation.setArg1(relArg1);
                        relation.setArg2(relArg2);
                        relation.setCategory(outcome);
                        relation.addToIndexes();
                        continue;
                    }
                    System.out.println("cannot classify " + timeMention.getCoveredText() + " and " + dischargeTime.getCoveredText());
                }
            }
        }
    }
}

