/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.timeml.util.TimeWordsExtractor;

public class TimeWordTypeExtractor<T extends Annotation>
implements FeatureExtractor1<T> {
    private static final String FEATURE_NAME = "TimeWordType";
    private static final String LOOKUP_PATH = "/org/apache/ctakes/temporal/time_word_types.txt";
    private Map<String, String> wordTypes = Maps.newHashMap();

    public TimeWordTypeExtractor() throws ResourceInitializationException {
        URL url = TimeWordsExtractor.class.getResource(LOOKUP_PATH);
        try {
            for (String line : Resources.readLines((URL)url, (Charset)Charsets.US_ASCII)) {
                String[] typeAndWord = line.split("\\s+");
                if (typeAndWord.length != 2) {
                    throw new IllegalArgumentException("Expected '<type> <word>', found: " + line);
                }
                this.wordTypes.put(typeAndWord[1], typeAndWord[0]);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        String type = this.wordTypes.get(focusAnnotation.getCoveredText().toLowerCase());
        List<Feature> features = type == null ? Collections.emptyList() : Collections.singletonList(new Feature(FEATURE_NAME, (Object)type));
        return features;
    }
}

