/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.duration;

import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import scala.collection.immutable.Set;

public class DurationTimeUnitFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String timeText = arg2.getCoveredText().toLowerCase();
        Set<TemporalUnit> units = Utils.runTimexParser(timeText);
        if (units == null) {
            features.add(new Feature("failed_normalization", (Object)true));
            return features;
        }
        for (TemporalUnit unit : units) {
            String coarseTimeUnit = Utils.putInBin(unit.toString());
            if (coarseTimeUnit == null) {
                features.add(new Feature("failed_normalization", (Object)true));
                return features;
            }
            Map<String, Float> distribution = Utils.convertToDistribution(coarseTimeUnit);
            float timeExpectedDuration = Utils.expectedDuration(distribution);
            features.add(new Feature("time_duration", (Object)Float.valueOf(timeExpectedDuration)));
        }
        return features;
    }
}

