/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.ctakes.temporal.ae.BackwardsTimeAnnotator;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.ae.EventAnnotator;
import org.apache.ctakes.temporal.pipelines.TemporalExtractionPipeline_ImplBase;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.utils.struct.CounterMap;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class ExtractDoctimerelPairProbabilities
extends TemporalExtractionPipeline_ImplBase {
    public static void main(String[] args) throws Exception {
        System.out.println("STarting...");
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        CollectionReader collectionReader = CollectionReaderFactory.createReaderFromPath((String)"../ctakes-core/desc/collection_reader/FilesInDirectoryCollectionReader.xml", (Object[])new Object[]{"InputDirectory", options.getInputDirectory()});
        AggregateBuilder aggregateBuilder = TemporalExtractionPipeline_ImplBase.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(EventAnnotator.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(BackwardsTimeAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/timeannotator/model.jar"), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/doctimerel/model.jar"), new String[0]);
        CounterMap corpusBefores = new CounterMap();
        HashMap<String, CounterMap> corpusPairs = new HashMap<String, CounterMap>();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            HashSet<String> docBefores = new HashSet<String>();
            HashSet<String> docAfters = new HashSet<String>();
            for (EventMention event : JCasUtil.select((JCas)jCas, EventMention.class)) {
                String dtr = event.getEvent().getProperties().getDocTimeRel();
                if (dtr.equals("BEFORE")) {
                    docBefores.add(event.getCoveredText().toLowerCase());
                    continue;
                }
                if (!dtr.equals("AFTER")) continue;
                docAfters.add(event.getCoveredText().toLowerCase());
            }
            for (String beforeEvent : docBefores) {
                corpusBefores.add((Object)beforeEvent, Integer.valueOf(docAfters.size()));
                if (!corpusPairs.containsKey(beforeEvent)) {
                    corpusPairs.put(beforeEvent, new CounterMap());
                }
                for (String afterEvent : docAfters) {
                    ((CounterMap)corpusPairs.get(beforeEvent)).add((Object)afterEvent);
                }
            }
        }
        for (String beforeEvent : corpusBefores.keySet()) {
            int total = corpusBefores.get((Object)beforeEvent);
            for (String afterEvent : ((CounterMap)corpusPairs.get(beforeEvent)).keySet()) {
                int count = ((CounterMap)corpusPairs.get(beforeEvent)).get((Object)afterEvent);
                System.out.println(String.format("%s : %s => %f", beforeEvent, afterEvent, Float.valueOf((float)count / (float)total)));
            }
        }
    }

    static interface Options {
        @Option(shortName={"i"}, description="specify the path to the directory containing the clinical notes to be processed")
        public String getInputDirectory();
    }
}

