/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class PreserveUMLSEventEventRelationsInGold
extends JCasAnnotator_ImplBase {
    public static final String GOLD_VIEW_NAME = "GoldView";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        JCas goldView;
        try {
            goldView = jCas.getView(GOLD_VIEW_NAME);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        try {
            systemView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
            RelationArgument arg1 = relation.getArg1();
            RelationArgument arg2 = relation.getArg2();
            if (!(arg1.getArgument() instanceof EventMention) || !(arg2.getArgument() instanceof EventMention)) continue;
            String event1Text = arg1.getArgument().getCoveredText().toLowerCase();
            String event2Text = arg2.getArgument().getCoveredText().toLowerCase();
            List coveringSystemEventMentions1 = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)arg1.getArgument().getBegin(), (int)arg1.getArgument().getEnd());
            List coveringSystemEventMentions2 = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)arg2.getArgument().getBegin(), (int)arg2.getArgument().getEnd());
            if (coveringSystemEventMentions1.size() > 0 && coveringSystemEventMentions2.size() > 0) {
                System.out.println("keeping: " + event1Text + "-" + event2Text);
                continue;
            }
            System.out.println("removing: " + event1Text + "-" + event2Text);
            arg1.removeFromIndexes();
            arg2.removeFromIndexes();
            relation.removeFromIndexes();
        }
        for (EventMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, EventMention.class))) {
            List coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)mention.getBegin(), (int)mention.getEnd());
            if (coveringSystemEventMentions.size() > 0) continue;
            mention.removeFromIndexes();
        }
    }
}

