/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import info.bethard.timenorm.DefaultTokenizer$;
import info.bethard.timenorm.Period;
import info.bethard.timenorm.PeriodSet;
import info.bethard.timenorm.Temporal;
import info.bethard.timenorm.TemporalExpressionParser;
import info.bethard.timenorm.TimeSpan;
import info.bethard.timenorm.TimeSpanSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.cr.XMIReader;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.temporal.ae.feature.duration.DurationEventTimeFeatureExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import scala.Function1;
import scala.collection.immutable.Set;
import scala.util.Try;

public class Utils {
    public static final String durationDistributionPath = "/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt";
    public static final String[] bins = new String[]{"second", "minute", "hour", "day", "week", "month", "year", "decade"};

    public static HashSet<String> getTimeUnits(String timex) {
        HashSet<String> timeUnits = new HashSet<String>();
        Set<TemporalUnit> units = Utils.runTimexParser(timex.toLowerCase());
        if (units == null) {
            return timeUnits;
        }
        for (TemporalUnit unit : units) {
            String bin = Utils.putInBin(unit.toString());
            if (bin == null) continue;
            timeUnits.add(bin);
        }
        return timeUnits;
    }

    public static Set<TemporalUnit> runTimexParser(String timex) {
        URL grammarURL = DurationEventTimeFeatureExtractor.class.getResource("/info/bethard/timenorm/en.grammar");
        TemporalExpressionParser parser = new TemporalExpressionParser(grammarURL, (Function1)DefaultTokenizer$.MODULE$);
        TimeSpan anchor = TimeSpan.of((int)2013, (int)12, (int)16);
        Try result = parser.parse(timex, anchor);
        Set units = null;
        if (result.isSuccess()) {
            Temporal temporal = (Temporal)result.get();
            if (temporal instanceof Period) {
                units = ((Period)temporal).unitAmounts().keySet();
            } else if (temporal instanceof PeriodSet) {
                units = ((PeriodSet)temporal).period().unitAmounts().keySet();
            } else if (temporal instanceof TimeSpan) {
                units = ((TimeSpan)temporal).period().unitAmounts().keySet();
            } else if (temporal instanceof TimeSpanSet) {
                Set fields = ((TimeSpanSet)temporal).fields().keySet();
                units = null;
            }
        }
        return units;
    }

    public static String getTimexMLValue(String timex) {
        URL grammarURL = DurationEventTimeFeatureExtractor.class.getResource("/info/bethard/timenorm/en.grammar");
        TemporalExpressionParser parser = new TemporalExpressionParser(grammarURL, (Function1)DefaultTokenizer$.MODULE$);
        TimeSpan anchor = TimeSpan.of((int)2013, (int)12, (int)16);
        Try result = parser.parse(timex, anchor);
        String value = null;
        if (result.isSuccess()) {
            Temporal temporal = (Temporal)result.get();
            value = temporal.timeMLValue();
        }
        return value;
    }

    public static String getTimexMLValue(String timex, String anchorStr) {
        String anchstr = Utils.getTimexMLValue(anchorStr);
        URL grammarURL = DurationEventTimeFeatureExtractor.class.getResource("/info/bethard/timenorm/en.grammar");
        TemporalExpressionParser parser = new TemporalExpressionParser(grammarURL, (Function1)DefaultTokenizer$.MODULE$);
        TimeSpan anchor = TimeSpan.fromTimeMLValue((String)anchstr);
        Try result = parser.parse(timex, anchor);
        String value = null;
        if (result.isSuccess()) {
            Temporal temporal = (Temporal)result.get();
            value = temporal.timeMLValue();
        }
        return value;
    }

    public static String putInBin(String timeUnit) {
        String singularAndLowercased;
        HashSet<String> allowableTimeUnits = new HashSet<String>(Arrays.asList(bins));
        if (allowableTimeUnits.contains(singularAndLowercased = timeUnit.substring(0, timeUnit.length() - 1).toLowerCase())) {
            return singularAndLowercased;
        }
        ImmutableMap mapping = ImmutableMap.builder().put((Object)"afternoon", (Object)"hour").put((Object)"evening", (Object)"hour").put((Object)"morning", (Object)"hour").put((Object)"night", (Object)"hour").put((Object)"fall", (Object)"month").put((Object)"winter", (Object)"month").put((Object)"spring", (Object)"month").put((Object)"summer", (Object)"month").put((Object)"quarteryear", (Object)"month").build();
        if (mapping.get(singularAndLowercased) != null) {
            return (String)mapping.get(singularAndLowercased);
        }
        return null;
    }

    public static float expectedDuration(Map<String, Float> distribution) {
        ImmutableMap timeUnitInSeconds = ImmutableMap.builder().put((Object)"second", (Object)1).put((Object)"minute", (Object)60).put((Object)"hour", (Object)3600).put((Object)"day", (Object)86400).put((Object)"week", (Object)604800).put((Object)"month", (Object)2592000).put((Object)"year", (Object)31536000).put((Object)"decade", (Object)315360000).build();
        float expectation = 0.0f;
        for (String unit : distribution.keySet()) {
            expectation += (float)((Integer)timeUnitInSeconds.get(unit)).intValue() * distribution.get(unit).floatValue();
        }
        return expectation / (float)((Integer)timeUnitInSeconds.get("decade")).intValue();
    }

    public static Map<String, Float> convertToDistribution(String timeUnit) {
        HashMap<String, Float> distribution = new HashMap<String, Float>();
        for (String bin : bins) {
            if (bin.equals(timeUnit)) {
                distribution.put(bin, Float.valueOf(1.0f));
                continue;
            }
            distribution.put(bin, Float.valueOf(0.0f));
        }
        return distribution;
    }

    public static String formatDistribution(String mentionText, Multiset<String> durationDistribution, String separator, boolean normalize) {
        LinkedList<String> distribution = new LinkedList<String>();
        distribution.add(mentionText);
        double total = 0.0;
        if (normalize) {
            for (String bin : bins) {
                total += (double)durationDistribution.count((Object)bin);
            }
        }
        for (String bin : bins) {
            if (normalize) {
                distribution.add(String.format("%s:%.3f", bin, (double)durationDistribution.count((Object)bin) / total));
                continue;
            }
            distribution.add(String.format("%s:%d", bin, durationDistribution.count((Object)bin)));
        }
        Joiner joiner = Joiner.on((String)separator);
        return joiner.join(distribution);
    }

    public static String getTextBetweenAnnotations(JCas jCas, Annotation arg1, Annotation arg2) {
        int windowSize = 5;
        String text = jCas.getDocumentText();
        int leftArgBegin = Math.min(arg1.getBegin(), arg2.getBegin());
        int rightArgEnd = Math.max(arg1.getEnd(), arg2.getEnd());
        int begin = Math.max(0, leftArgBegin - 5);
        int end = Math.min(text.length(), rightArgEnd + 5);
        return text.substring(begin, end).replaceAll("[\r\n]", " ");
    }

    public static String lemmatize(String word, String pos) throws IOException {
        String ENG_LEMMATIZER_DATA_FILE = "org/apache/ctakes/dependency/parser/models/lemmatizer/dictionary-1.3.1.jar";
        InputStream lemmatizerModel = FileLocator.getAsStream((String)"org/apache/ctakes/dependency/parser/models/lemmatizer/dictionary-1.3.1.jar");
        AbstractMPAnalyzer lemmatizer = EngineGetter.getMPAnalyzer((String)"en", (InputStream)lemmatizerModel);
        String lemma = lemmatizer.getLemma(word, pos);
        lemmatizerModel.close();
        return lemma;
    }

    public static String getPosTag(JCas systemView, Annotation annotation) {
        List coveringBaseTokens = JCasUtil.selectCovered((JCas)systemView, BaseToken.class, (int)annotation.getBegin(), (int)annotation.getEnd());
        if (coveringBaseTokens.size() < 1) {
            return null;
        }
        return ((BaseToken)coveringBaseTokens.get(0)).getPartOfSpeech();
    }

    public static String normalizeEventText(JCas jCas, Annotation annotation) throws AnalysisEngineProcessException {
        String text;
        JCas systemView;
        try {
            systemView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        List coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)annotation.getBegin(), (int)annotation.getEnd());
        for (EventMention systemEventMention : coveringSystemEventMentions) {
            if (systemEventMention.getTypeID() == 0) continue;
            return annotation.getCoveredText().toLowerCase();
        }
        String pos = Utils.getPosTag(systemView, annotation);
        if (pos == null) {
            return annotation.getCoveredText().toLowerCase();
        }
        if (pos.startsWith("V")) {
            try {
                text = Utils.lemmatize(annotation.getCoveredText().toLowerCase(), pos);
            }
            catch (IOException e) {
                System.out.println("couldn't lemmatize: " + annotation.getCoveredText());
                e.printStackTrace();
                return annotation.getCoveredText().toLowerCase();
            }
        } else {
            text = annotation.getCoveredText();
        }
        return text.toLowerCase();
    }

    public static CollectionReader getCollectionReader(List<File> inputFiles) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputFiles) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static List<File> getFilesFor(List<Integer> patientSets, File inputDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : patientSets) {
            final int setNum = set;
            for (File file : inputDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(String.format("ID%03d", setNum));
                }
            })) {
                if (file.isHidden()) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static void writeInstance(String label, List<Feature> features, String fileName) {
        StringBuffer output = new StringBuffer(label);
        for (Feature feature : features) {
            String nameValuePair;
            String cleanedUpValue;
            String cleanedUpName;
            if (feature.getName() == null || feature.getValue() == null) continue;
            String name = feature.getName();
            Object value = feature.getValue();
            if (value instanceof String) {
                cleanedUpName = name.replace(",", "COMMA").replace(":", "COLON").replace("\n", "EOL");
                cleanedUpValue = value.toString().replace(",", "COMMA").replace(":", "COLON").replace("\n", "EOL");
                nameValuePair = String.format(",%s-%s:%s", cleanedUpName, cleanedUpValue, 1);
            } else {
                if (!(value instanceof Integer)) continue;
                cleanedUpName = name.replace(",", "COMMA").replace(":", "COLON").replace("\n", "EOL");
                cleanedUpValue = value.toString().replace(",", "COMMA").replace(":", "COLON").replace("\n", "EOL");
                nameValuePair = String.format(",%s:%s", cleanedUpName, cleanedUpValue);
            }
            output.append(nameValuePair);
        }
        try {
            Files.append((CharSequence)(output + "\n"), (File)new File(fileName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("could not write to output file!");
        }
    }

    public static void main(String[] args) {
        HashSet<String> timeUnits = Utils.getTimeUnits("three months");
        System.out.println(timeUnits);
    }

    public static class Callback
    implements LineProcessor<Map<String, Map<String, Float>>> {
        private Map<String, Map<String, Float>> textToDistribution = new HashMap<String, Map<String, Float>>();

        public boolean processLine(String line) throws IOException {
            String[] elements = line.split(", ");
            HashMap<String, Float> distribution = new HashMap<String, Float>();
            for (int durationBinNumber = 1; durationBinNumber < elements.length; ++durationBinNumber) {
                String[] durationAndValue = elements[durationBinNumber].split(":");
                distribution.put(durationAndValue[0], Float.valueOf(Float.parseFloat(durationAndValue[1])));
            }
            this.textToDistribution.put(elements[0], distribution);
            return true;
        }

        public Map<String, Map<String, Float>> getResult() {
            return this.textToDistribution;
        }
    }
}

