/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.EventEventCRFRelationAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.I2B2Data;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.temporal.utils.AnnotationIdCollection;
import org.apache.ctakes.temporal.utils.TLinkTypeArray2;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.crfsuite.CrfSuiteStringOutcomeDataWriter;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfEventEventCRFRelations
extends EvaluationOfTemporalRelations_ImplBase {
    protected static EvaluationOfEventTimeRelations.ParameterSettings flatParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "linear", 10.0, 1.0, "linear", CompositeKernel.ComboOperator.VECTOR_ONLY, DEFAULT_TK, DEFAULT_LAMBDA);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allBagsParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 100.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 10.0, 1.0, "polynomial", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings ftParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 1.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    private static Boolean recallModeEvaluation = true;
    private boolean baseline;
    protected boolean useClosure;
    protected boolean useGoldAttributes;
    protected boolean skipTrain = false;

    public static void main(String[] args) throws Exception {
        TempRelOptions options = (TempRelOptions)CliFactory.parseArguments(TempRelOptions.class, (String[])args);
        List<Integer> trainItems = null;
        List<Integer> devItems = null;
        List<Integer> testItems = null;
        List<Integer> patientSets = options.getPatients().getList();
        if (options.getXMLFormat() == Evaluation_ImplBase.XMLFormat.I2B2) {
            trainItems = I2B2Data.getTrainPatientSets(options.getXMLDirectory());
            devItems = I2B2Data.getDevPatientSets(options.getXMLDirectory());
            testItems = I2B2Data.getTestPatientSets(options.getXMLDirectory());
        } else {
            trainItems = THYMEData.getPatientSets(patientSets, options.getTrainRemainders().getList());
            devItems = THYMEData.getPatientSets(patientSets, options.getDevRemainders().getList());
            testItems = THYMEData.getPatientSets(patientSets, options.getTestRemainders().getList());
        }
        EvaluationOfEventTimeRelations.ParameterSettings params = allParams;
        try {
            File workingDir = new File("target/eval/thyme/");
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            if (options.getUseTmp()) {
                File tempModelDir = File.createTempFile("temporal", null, workingDir);
                tempModelDir.delete();
                tempModelDir.mkdir();
                workingDir = tempModelDir;
            }
            EvaluationOfEventEventCRFRelations evaluation = new EvaluationOfEventEventCRFRelations(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getClosure(), options.getPrintErrors(), options.getPrintFormattedRelations(), options.getBaseline(), options.getUseGoldAttributes(), options.getKernelParams(), params);
            if (options.getI2B2Output() != null) {
                evaluation.setI2B2Output(options.getI2B2Output());
            }
            List<Integer> training = trainItems;
            List<Integer> testing = null;
            if (options.getTest()) {
                training.addAll(devItems);
                testing = testItems;
            } else {
                testing = devItems;
            }
            evaluation.printErrors = false;
            evaluation.skipTrain = options.getSkipTrain();
            if (evaluation.skipTrain && options.getTest()) {
                evaluation.prepareXMIsFor(testing);
            } else {
                evaluation.prepareXMIsFor(patientSets);
            }
            evaluation.printErrors = true;
            params.stats = (AnnotationStatistics)evaluation.trainAndTest(training, testing);
            System.err.println(params.stats);
            if (options.getUseTmp()) {
                FileUtils.deleteRecursive((File)workingDir);
            }
        }
        catch (ResourceInitializationException e) {
            System.err.println("Error with parameter settings: " + params);
            e.printStackTrace();
        }
    }

    public EvaluationOfEventEventCRFRelations(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean useClosure, boolean printErrors, boolean printRelations, boolean baseline, boolean useGoldAttributes, String kernelParams, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory, printErrors, printRelations, params);
        this.params = params;
        this.useClosure = useClosure;
        this.printErrors = printErrors;
        this.printRelations = printRelations;
        this.useGoldAttributes = useGoldAttributes;
        this.baseline = baseline;
        this.kernelParams = kernelParams == null ? null : kernelParams.split(" ");
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        if (this.skipTrain) {
            return;
        }
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class, BinaryTextRelation.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveCrossSentenceRelations.class, (Object[])new Object[0]), new String[0]);
        if (!this.useGoldAttributes) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveGoldAttributes.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.PreserveEventEventRelations.class, (Object[])new Object[0]), new String[0]);
        if (this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.Overlap2Contains.class, (Object[])new Object[0]), new String[0]);
        boolean expandEvent = true;
        aggregateBuilder.add(EventEventCRFRelationAnnotator.createDataWriterDescription(CrfSuiteStringOutcomeDataWriter.class, new File(directory, "event-event"), this.params.probabilityOfKeepingANegativeExample, expandEvent), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        JarClassifierBuilder.trainAndPackage((File)new File(directory, "event-event"), (String[])new String[]{"-p", "c2=0.3"});
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        this.useClosure = false;
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveCrossSentenceRelations.class, (Object[])new Object[]{"SentenceView", "_InitialView", "RelationView", "GoldView"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.PreserveEventEventRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(EventEventCRFRelationAnnotator.createAnnotatorDescription(new File(directory, "event-event")), new String[0]);
        if (this.i2b2Output != null) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.WriteAnaforaXML.class, (Object[])new Object[]{"PARAM_OUTPUT_DIR", this.i2b2Output}), new String[]{"TimexView", "_InitialView"});
        }
        Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(BinaryTextRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator jcasIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        JCas jCas = null;
        while (jcasIter.hasNext()) {
            Object relation2;
            jCas = jcasIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldRelations = JCasUtil.select((JCas)goldView, BinaryTextRelation.class);
            Collection systemRelations = JCasUtil.select((JCas)systemView, BinaryTextRelation.class);
            stats.add(goldRelations, systemRelations, (Function)getSpan, getOutcome);
            if (this.printRelations) {
                URI uri = ViewUriUtil.getURI((JCas)jCas);
                String[] path = uri.getPath().split("/");
                EvaluationOfEventEventCRFRelations.printRelationAnnotations((String)path[path.length - 1], systemRelations);
            }
            if (!this.printErrors) continue;
            HashMap goldMap = Maps.newHashMap();
            for (Object relation2 : goldRelations) {
                goldMap.put(new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation2), relation2);
            }
            HashMap systemMap = Maps.newHashMap();
            relation2 = systemRelations.iterator();
            while (relation2.hasNext()) {
                BinaryTextRelation relation3 = (BinaryTextRelation)relation2.next();
                systemMap.put(new RelationExtractorEvaluation.HashableArguments(relation3), relation3);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
        }
        return stats;
    }

    @PipeBitInfo(name="TLink Closure Engine", description="Performs closure on Temporal Relations", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddClosure
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashMultimap annotationsToRelation = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                String relationType = relation.getCategory();
                if (!AddClosure.validTemporalType(relationType)) continue;
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                annotationsToRelation.put(Arrays.asList(arg1, arg2), (Object)relation);
            }
            for (List span : Lists.newArrayList((Iterable)annotationsToRelation.keySet())) {
                Collection relations = annotationsToRelation.get((Object)span);
                if (relations.size() <= 1) continue;
                HashSet types = Sets.newHashSet();
                for (BinaryTextRelation relation : relations) {
                    types.add(relation.getCategory());
                }
                if (types.size() > 1) {
                    for (BinaryTextRelation relation : Lists.newArrayList((Iterable)relations)) {
                        annotationsToRelation.remove((Object)span, (Object)relation);
                        relation.getArg1().removeFromIndexes();
                        relation.getArg2().removeFromIndexes();
                        relation.removeFromIndexes();
                    }
                    continue;
                }
                if (types.size() != 1) continue;
                for (int i = 1; i < relations.size(); ++i) {
                    BinaryTextRelation relation;
                    relation = (BinaryTextRelation)relations.toArray()[i];
                    annotationsToRelation.remove((Object)span, (Object)relation);
                    relation.getArg1().removeFromIndexes();
                    relation.getArg2().removeFromIndexes();
                    relation.removeFromIndexes();
                }
            }
            ArrayList<BinaryTextRelation> temporalRelation = new ArrayList<BinaryTextRelation>(annotationsToRelation.values());
            if (!temporalRelation.isEmpty()) {
                TLinkTypeArray2 relationArray = new TLinkTypeArray2(temporalRelation, new AnnotationIdCollection(temporalRelation));
                int addedCount = 0;
                for (BinaryTextRelation relation : relationArray.getClosedTlinks(jCas)) {
                    Collection relations;
                    RelationArgument arg1 = relation.getArg1();
                    RelationArgument arg2 = relation.getArg2();
                    String relationType = relation.getCategory();
                    if (relationType.equals("CONTAINED-BY") || relationType.equals("AFTER") || !(relations = annotationsToRelation.get(Arrays.asList(arg1.getArgument(), arg2.getArgument()))).isEmpty()) continue;
                    arg1.addToIndexes();
                    arg2.addToIndexes();
                    relation.addToIndexes();
                    ++addedCount;
                }
                System.out.println("**************************************************************");
                System.out.println("Finally added closure relations: " + addedCount);
                System.out.println("**************************************************************");
            }
        }

        private static boolean validTemporalType(String relationType) {
            return relationType.equals("CONTAINS") || relationType.equals("OVERLAP") || relationType.equals("BEFORE") || relationType.equals("ENDS-ON") || relationType.equals("BEGINS-ON");
        }
    }

    @PipeBitInfo(name="Reverse Overlap TLinker", description="Adds Overlap temporal relations with arguments flipped.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddFlippedOverlap
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashSet overlapRelations = Sets.newHashSet();
            HashMultimap overlaps = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("OVERLAP")) continue;
                overlapRelations.add(relation);
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                overlaps.put((Object)arg1, (Object)arg2);
            }
            for (BinaryTextRelation orelation : overlapRelations) {
                Annotation argA = orelation.getArg1().getArgument();
                Annotation argB = orelation.getArg2().getArgument();
                if (overlaps.containsEntry((Object)argB, (Object)argA)) continue;
                RelationArgument arg1 = new RelationArgument(jCas);
                arg1.setArgument(argB);
                RelationArgument arg2 = new RelationArgument(jCas);
                arg2.setArgument(argA);
                BinaryTextRelation relation = new BinaryTextRelation(jCas);
                relation.setArg1(arg1);
                relation.setArg2(arg2);
                relation.setCategory("OVERLAP");
                arg1.addToIndexes();
                arg2.addToIndexes();
                relation.addToIndexes();
                overlaps.put((Object)argB, (Object)argA);
            }
        }
    }

    @PipeBitInfo(name="TLink Overlap Adder", description="Adds an Overlap temporal relation for each Contains temporal relation.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddContain2Overlap
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashSet containsRelations = Sets.newHashSet();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("CONTAINS")) continue;
                containsRelations.add(relation);
            }
            for (BinaryTextRelation relation : containsRelations) {
                RelationArgument arg1 = (RelationArgument)relation.getArg1().clone();
                RelationArgument arg2 = (RelationArgument)relation.getArg2().clone();
                BinaryTextRelation newrelation = new BinaryTextRelation(jCas);
                newrelation.setArg1(arg1);
                newrelation.setArg2(arg2);
                newrelation.setCategory("OVERLAP");
                arg1.addToIndexes();
                arg2.addToIndexes();
                newrelation.addToIndexes();
            }
        }
    }

    @PipeBitInfo(name="Transitive Contains Adder", description="Adds Contains temporal relations for annotations / relations in contain other relations.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddTransitiveContainsRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashMultimap isContainedIn = HashMultimap.create();
            HashMultimap contains = HashMultimap.create();
            HashSet containsRelations = Sets.newHashSet();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("CONTAINS")) continue;
                containsRelations.add(relation);
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                contains.put((Object)arg1, (Object)arg2);
                isContainedIn.put((Object)arg2, (Object)arg1);
            }
            ArrayDeque<Annotation> todo = new ArrayDeque<Annotation>(isContainedIn.keySet());
            while (!todo.isEmpty()) {
                Annotation next = (Annotation)todo.removeFirst();
                for (Annotation parent : Lists.newArrayList((Iterable)isContainedIn.get((Object)next))) {
                    for (Annotation grandParent : Lists.newArrayList((Iterable)isContainedIn.get((Object)parent))) {
                        if (isContainedIn.containsEntry((Object)next, (Object)grandParent)) continue;
                        isContainedIn.put((Object)next, (Object)grandParent);
                        contains.put((Object)grandParent, (Object)next);
                        for (Annotation child : contains.get((Object)next)) {
                            todo.add(child);
                        }
                    }
                }
            }
            for (BinaryTextRelation relation : containsRelations) {
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
            for (Annotation contained : isContainedIn.keySet()) {
                for (Annotation container : isContainedIn.get((Object)contained)) {
                    RelationArgument arg1 = new RelationArgument(jCas);
                    arg1.setArgument(container);
                    RelationArgument arg2 = new RelationArgument(jCas);
                    arg2.setArgument(contained);
                    BinaryTextRelation relation = new BinaryTextRelation(jCas);
                    relation.setArg1(arg1);
                    relation.setArg2(arg2);
                    relation.setCategory("CONTAINS");
                    arg1.addToIndexes();
                    arg2.addToIndexes();
                    relation.addToIndexes();
                }
            }
        }
    }

    public static class RemoveRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveCrossSentenceRelations
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_SENTENCE_VIEW = "SentenceView";
        @ConfigurationParameter(name="SentenceView", mandatory=false)
        private String sentenceViewName = "_InitialView";
        public static final String PARAM_RELATION_VIEW = "RelationView";
        @ConfigurationParameter(name="RelationView", mandatory=false)
        private String relationViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas relationView;
            JCas sentenceView;
            try {
                sentenceView = jCas.getView(this.sentenceViewName);
                relationView = jCas.getView(this.relationViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap sentenceIndex = Maps.newHashMap();
            int index = -1;
            for (Sentence sentence : JCasUtil.select((JCas)sentenceView, Sentence.class)) {
                ++index;
                for (EventMention event : JCasUtil.selectCovered((JCas)relationView, EventMention.class, (AnnotationFS)sentence)) {
                    sentenceIndex.put(event, index);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)relationView, TimeMention.class, (AnnotationFS)sentence)) {
                    sentenceIndex.put(time, index);
                }
            }
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)relationView, BinaryTextRelation.class))) {
                Integer sent1 = (Integer)sentenceIndex.get(relation.getArg1().getArgument());
                Integer sent2 = (Integer)sentenceIndex.get(relation.getArg2().getArgument());
                if (sent1 != null && sent2 != null && sent1.equals(sent2)) continue;
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    @PipeBitInfo(name="Event-Event TLinker", description="Adds Event -to- Event temporal relations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddEEPotentialRelations
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_RELATION_VIEW = "RelationView";
        @ConfigurationParameter(name="RelationView", mandatory=false)
        private String relationViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas relationView;
            try {
                relationView = jCas.getView(this.relationViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashSet<List<EventMention>> relationLookup = new HashSet<List<EventMention>>();
            Map coveringMap = JCasUtil.indexCovering((JCas)relationView, EventMention.class, EventMention.class);
            for (TemporalTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)relationView, TemporalTextRelation.class))) {
                List<EventMention> key;
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                if (!(arg1 instanceof EventMention) || !(arg2 instanceof EventMention)) continue;
                EventMention event1 = (EventMention)arg1;
                EventMention event2 = (EventMention)arg2;
                for (EventMention covEventA : (Collection)coveringMap.get(event1)) {
                    key = Arrays.asList(covEventA, event2);
                    if (!relationLookup.contains(key) && !AddEEPotentialRelations.hasOverlap((Annotation)covEventA, (Annotation)event2)) {
                        relationLookup.add(key);
                        AddEEPotentialRelations.createRelation(relationView, (Annotation)covEventA, (Annotation)event2, relation.getCategory());
                    }
                    for (EventMention covEventB : (Collection)coveringMap.get(event2)) {
                        key = Arrays.asList(covEventA, covEventB);
                        if (relationLookup.contains(key) || AddEEPotentialRelations.hasOverlap((Annotation)covEventA, (Annotation)covEventB)) continue;
                        relationLookup.add(key);
                        AddEEPotentialRelations.createRelation(relationView, (Annotation)covEventA, (Annotation)covEventB, relation.getCategory());
                    }
                }
                for (EventMention covEventB : (Collection)coveringMap.get(event2)) {
                    key = Arrays.asList(event1, covEventB);
                    if (relationLookup.contains(key) || AddEEPotentialRelations.hasOverlap((Annotation)event1, (Annotation)covEventB)) continue;
                    relationLookup.add(key);
                    AddEEPotentialRelations.createRelation(relationView, (Annotation)event1, (Annotation)covEventB, relation.getCategory());
                }
            }
        }

        private static boolean hasOverlap(Annotation event1, Annotation event2) {
            if (event1.getEnd() >= event2.getBegin() && event1.getEnd() <= event2.getEnd()) {
                return true;
            }
            return event2.getEnd() >= event1.getBegin() && event2.getEnd() <= event1.getEnd();
        }

        private static void createRelation(JCas jCas, Annotation arg1, Annotation arg2, String category) {
            RelationArgument relArg1 = new RelationArgument(jCas);
            relArg1.setArgument(arg1);
            relArg1.setRole("Arg1");
            relArg1.addToIndexes();
            RelationArgument relArg2 = new RelationArgument(jCas);
            relArg2.setArgument(arg2);
            relArg2.setRole("Arg2");
            relArg2.addToIndexes();
            TemporalTextRelation relation = new TemporalTextRelation(jCas);
            relation.setArg1(relArg1);
            relation.setArg2(relArg2);
            relation.setCategory(category);
            relation.addToIndexes();
        }
    }

    public static class RemoveNonUMLSEvents
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_GOLD_VIEW = "GoldView";
        @ConfigurationParameter(name="GoldView", mandatory=false)
        private String goldViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            JCas sysView;
            try {
                sysView = jCas.getView("_InitialView");
                goldView = jCas.getView(PARAM_GOLD_VIEW);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (TemporalTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, TemporalTextRelation.class))) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                boolean arg1Valid = false;
                boolean arg2Valid = false;
                for (EventMention event : JCasUtil.selectCovered((JCas)sysView, EventMention.class, (AnnotationFS)arg1)) {
                    if (event.getClass().equals(EventMention.class)) continue;
                    arg1Valid = true;
                    break;
                }
                for (EventMention event : JCasUtil.selectCovered((JCas)sysView, EventMention.class, (AnnotationFS)arg2)) {
                    if (event.getClass().equals(EventMention.class)) continue;
                    arg2Valid = true;
                    break;
                }
                if (arg1Valid && arg2Valid) continue;
                arg1.removeFromIndexes();
                arg2.removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveLongDistanceEERelations
    extends JCasAnnotator_ImplBase {
        private String systemViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            JCas systemView;
            int sizeLimit = 0;
            try {
                systemView = jCas.getView(this.systemViewName);
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (TemporalTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, TemporalTextRelation.class))) {
                RelationArgument arg1 = relation.getArg1();
                RelationArgument arg2 = relation.getArg2();
                List words = JCasUtil.selectBetween((JCas)systemView, EventMention.class, (AnnotationFS)arg1.getArgument(), (AnnotationFS)arg2.getArgument());
                if (words.size() <= sizeLimit) continue;
                arg1.removeFromIndexes();
                arg2.removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    static interface TempRelOptions
    extends Evaluation_ImplBase.Options {
        @Option
        public boolean getPrintFormattedRelations();

        @Option
        public boolean getBaseline();

        @Option
        public boolean getClosure();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getUseGoldAttributes();

        @Override
        @Option
        public boolean getSkipTrain();
    }
}

