/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.keras;

import com.google.common.annotations.Beta;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.util.featurevector.FeatureVector;

@Beta
public abstract class ScriptStringOutcomeClassifier
extends Classifier_ImplBase<FeatureVector, String, Integer> {
    File modelDir = null;
    Process classifierProcess = null;
    PrintStream toClassifier = null;
    BufferedReader reader = null;
    BufferedReader errReader = null;
    Logger logger = UIMAFramework.getLogger(ScriptStringOutcomeClassifier.class);

    public ScriptStringOutcomeClassifier(FeaturesEncoder<FeatureVector> featuresEncoder, OutcomeEncoder<String, Integer> outcomeEncoder, File modelDir, File scriptDir) {
        super(featuresEncoder, outcomeEncoder);
        this.modelDir = modelDir;
        File classifyScript = null;
        for (File file : scriptDir.listFiles()) {
            if (!file.getName().startsWith("classify.sh")) continue;
            if (classifyScript != null) {
                throw new RuntimeException("There are multiple files named classify.*");
            }
            classifyScript = file;
        }
        if (classifyScript == null) {
            throw new RuntimeException("There are no files named classify.*");
        }
        try {
            this.classifierProcess = Runtime.getRuntime().exec(new String[]{classifyScript.getAbsolutePath(), modelDir.getAbsolutePath()});
            this.toClassifier = new PrintStream(this.classifierProcess.getOutputStream());
            this.reader = new BufferedReader(new InputStreamReader(this.classifierProcess.getInputStream()));
            this.errReader = new BufferedReader(new InputStreamReader(this.classifierProcess.getErrorStream()));
            this.errReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String classify(List<Feature> features) throws CleartkProcessingException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < features.size(); ++i) {
            buf.append(features.get(i).getValue());
            if (i >= features.size() - 1) continue;
            buf.append(" ");
        }
        this.toClassifier.println(buf);
        this.toClassifier.flush();
        String line = "";
        String eLine = "";
        try {
            line = this.reader.readLine();
            if (line == null) {
                while ((eLine = this.errReader.readLine()) != null) {
                    this.logger.log(Level.SEVERE, eLine);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return line;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.toClassifier.print('\n');
        this.classifierProcess.waitFor();
    }
}

