/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.ae.SentenceDetector;
import org.apache.ctakes.core.ae.TokenizerAnnotatorPTB;
import org.apache.ctakes.temporal.ae.THYMEKnowtatorXMLReader;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class CheckKnowtatorAnnotations {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : options.getPatients().getList()) {
            File setTextDirectory = new File(options.getRawTextDirectory(), "doc" + set);
            for (File file : setTextDirectory.listFiles()) {
                files.add(file);
            }
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(THYMEKnowtatorXMLReader.class, (Object[])new Object[]{"knowtatorXMLDirectory", options.getKnowtatorXMLDirectory()}), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.SegmentsFromBracketedSectionTagsAnnotator.class, (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(SentenceDetector.class, (Object[])new Object[]{"SentenceModelFile", "org/apache/ctakes/core/sentdetect/sd-med-model.zip"}), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(TokenizerAnnotatorPTB.class, (Object[])new Object[0]), new String[0]);
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{builder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            for (EventMention event : JCasUtil.select((JCas)jCas, EventMention.class)) {
                List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)event);
                if (tokens.size() > 1) {
                    System.err.printf("Multi-token event \"%s\" in %s\n", event.getCoveredText(), ViewUriUtil.getURI((JCas)jCas));
                }
                if (!event.getCoveredText().contains(" ")) continue;
                System.err.printf("Whitespace in event \"%s\" in %s\n", event.getCoveredText(), ViewUriUtil.getURI((JCas)jCas));
            }
        }
    }

    private static interface Options {
        @Option(longName={"text"})
        public File getRawTextDirectory();

        @Option(longName={"xml"})
        public File getKnowtatorXMLDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();
    }
}

