/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;

public class SMOTEplus {
    protected List<Instance<String>> minorityInsts = Lists.newArrayList();
    protected Table<Instance<String>, String, Integer> instanceFeatureCount;
    protected Table<Instance<String>, Instance<String>, Double> interInstanceDistance;
    protected List<Instance<String>> syntheticInsts = Lists.newArrayList();
    protected final int numOfNearestNeighbors;

    public SMOTEplus(int numNeighbors) {
        this.instanceFeatureCount = HashBasedTable.create();
        this.interInstanceDistance = HashBasedTable.create();
        this.numOfNearestNeighbors = numNeighbors;
    }

    public Iterable<Instance<String>> populateMinorityClass() {
        for (Instance<String> instance : this.minorityInsts) {
            for (Object feature : instance.getFeatures()) {
                this.instanceFeatureCount.put(instance, (Object)this.getFeatureName((Feature)feature), (Object)1);
            }
        }
        for (Instance<String> aMinorityInst : this.minorityInsts) {
            LinkedList<Object[]> distToMe = new LinkedList<Object[]>();
            for (Instance bInst : this.instanceFeatureCount.rowKeySet()) {
                double distance = this.calculateDistance(aMinorityInst, (Instance<String>)bInst);
                distToMe.add(new Object[]{distance, bInst});
            }
            Collections.sort(distToMe, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    double dist1 = (Double)((Object[])o1)[0];
                    double dist2 = (Double)((Object[])o2)[0];
                    return (int)Math.ceil(dist1 - dist2);
                }
            });
            Iterator neighborIter = distToMe.iterator();
            for (int idx = 0; neighborIter.hasNext() && idx < this.numOfNearestNeighbors; ++idx) {
                Instance nearestNeighbor = (Instance)((Object[])neighborIter.next())[1];
                Instance<String> sytheticInst = this.generateInstance(aMinorityInst, (Instance<String>)nearestNeighbor);
                this.syntheticInsts.add(sytheticInst);
            }
        }
        return this.syntheticInsts;
    }

    private Instance<String> generateInstance(Instance<String> aMinorityInst, Instance<String> nearestNeighbor) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Feature feature : aMinorityInst.getFeatures()) {
            String featureName = this.getFeatureName(feature);
            Integer valB = (Integer)this.instanceFeatureCount.get(nearestNeighbor, (Object)featureName);
            if (valB == null) continue;
            features.add(feature);
        }
        String outcome = (String)nearestNeighbor.getOutcome();
        Instance syntheticInst = new Instance((Object)outcome, features);
        return syntheticInst;
    }

    private double calculateDistance(Instance<String> instA, Instance<String> instB) {
        double distance = 0.0;
        Double dis1 = (Double)this.interInstanceDistance.get(instA, instB);
        Double dis2 = (Double)this.interInstanceDistance.get(instB, instA);
        if (dis1 == null && dis2 == null) {
            for (Feature feature : instA.getFeatures()) {
                String featureName = this.getFeatureName(feature);
                Integer valB = (Integer)this.instanceFeatureCount.get(instB, (Object)featureName);
                if (valB != null) continue;
                distance += 1.0;
            }
            distance = Math.pow(distance, 0.5);
            this.interInstanceDistance.put(instA, instB, (Object)distance);
        } else {
            distance = dis1 == null ? dis2 : dis1;
        }
        return distance;
    }

    public String getFeatureName(Feature feature) {
        String featureName = feature.getName();
        Object featureValue = feature.getValue();
        return featureName + ":" + featureValue;
    }

    public void addInstance(Instance<String> minorityInst) {
        this.minorityInsts.add(minorityInst);
    }
}

