/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.train;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringTrainSpace
extends AbstractTrainSpace {
    private StringModel s_model;
    private int l_cutoff;
    private int f_cutoff;
    private List<Pair<String, StringFeatureVector>> s_instances;
    private ObjectIntOpenHashMap<String> m_labels;
    private Map<String, ObjectIntOpenHashMap<String>> m_features;

    public StringTrainSpace(boolean hasWeight, int labelCutoff, int featureCutoff) {
        super(new StringModel(), hasWeight);
        this.s_model = (StringModel)this.m_model;
        this.l_cutoff = labelCutoff;
        this.f_cutoff = featureCutoff;
        this.s_instances = new ArrayList<Pair<String, StringFeatureVector>>();
        this.m_labels = new ObjectIntOpenHashMap();
        this.m_features = new HashMap<String, ObjectIntOpenHashMap<String>>();
    }

    @Override
    public void printInstances(PrintStream fout) {
        int size = this.s_instances.size();
        Object[] instances = new String[size];
        for (int i = 0; i < size; ++i) {
            Pair<String, StringFeatureVector> p = this.s_instances.get(i);
            instances[i] = (String)p.o1 + " " + ((StringFeatureVector)p.o2).toString();
        }
        Arrays.sort(instances);
        for (Object instance : instances) {
            fout.println((String)instance);
        }
    }

    public void addInstance(String label, StringFeatureVector vector) {
        this.addLexica(label, vector);
        this.s_instances.add(new Pair<String, StringFeatureVector>(label, vector));
    }

    @Override
    public void addInstance(String line) {
        Pair<String, StringFeatureVector> instance = StringTrainSpace.toInstance(line, this.b_weight);
        this.addInstance((String)instance.o1, (StringFeatureVector)instance.o2);
    }

    public void appendSpace(StringTrainSpace space) {
        this.appendSpaceLabels(space);
        this.appendSpaceFeatures(space);
        this.appendSpaceInstances(space);
    }

    private void appendSpaceLabels(StringTrainSpace space) {
        ObjectIntOpenHashMap<String> mLabels = space.m_labels;
        for (ObjectCursor cur : mLabels.keys()) {
            String label = (String)cur.value;
            this.m_labels.put((Object)label, this.m_labels.get((Object)label) + mLabels.get((Object)label));
        }
    }

    private void appendSpaceFeatures(StringTrainSpace space) {
        Map<String, ObjectIntOpenHashMap<String>> mFeatures = space.m_features;
        for (String type : mFeatures.keySet()) {
            ObjectIntOpenHashMap<String> sMap = mFeatures.get(type);
            if (this.m_features.containsKey(type)) {
                ObjectIntOpenHashMap<String> tMap = this.m_features.get(type);
                for (ObjectCursor cur : sMap.keys()) {
                    String value = (String)cur.value;
                    tMap.put((Object)value, tMap.get((Object)value) + sMap.get((Object)value));
                }
                continue;
            }
            this.m_features.put(type, sMap);
        }
    }

    private void appendSpaceInstances(StringTrainSpace space) {
        this.s_instances.addAll(space.s_instances);
    }

    public void clear() {
        this.s_instances.clear();
        this.m_labels.clear();
        this.m_features.clear();
    }

    private void addLexica(String label, StringFeatureVector vector) {
        this.addLexicaLabel(label);
        this.addLexicaFeatures(vector);
    }

    private void addLexicaLabel(String label) {
        this.m_labels.put((Object)label, this.m_labels.get((Object)label) + 1);
    }

    private void addLexicaFeatures(StringFeatureVector vector) {
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            ObjectIntOpenHashMap<String> map;
            String type = vector.getType(i);
            String value = vector.getValue(i);
            if (this.m_features.containsKey(type)) {
                map = this.m_features.get(type);
                map.put((Object)value, map.get((Object)value) + 1);
                continue;
            }
            map = new ObjectIntOpenHashMap<String>();
            map.put((Object)value, 1);
            this.m_features.put(type, map);
        }
    }

    @Override
    public void build(boolean clearInstances) {
        System.out.println("Building:");
        this.initModelMaps();
        int size = this.s_instances.size();
        for (int i = 0; i < size; ++i) {
            Pair<String, StringFeatureVector> instance = this.s_instances.get(i);
            int y = this.s_model.getLabelIndex((String)instance.o1);
            if (y < 0) continue;
            SparseFeatureVector x = this.s_model.toSparseFeatureVector((StringFeatureVector)instance.o2);
            this.a_ys.add(y);
            this.a_xs.add(x.getIndices());
            if (this.b_weight) {
                this.a_vs.add(x.getWeights());
            }
            if (i % 100000 != 0) continue;
            System.out.print(".");
        }
        this.a_ys.trimToSize();
        this.a_xs.trimToSize();
        if (this.b_weight) {
            this.a_vs.trimToSize();
        }
        System.out.println();
        System.out.println("- # of labels   : " + this.s_model.getLabelSize());
        System.out.println("- # of features : " + this.s_model.getFeatureSize());
        System.out.println("- # of instances: " + this.a_ys.size());
        if (clearInstances) {
            this.s_instances.clear();
        }
    }

    @Override
    public void build() {
        this.build(true);
    }

    private void initModelMaps() {
        for (ObjectCursor cur : this.m_labels.keys()) {
            String label = (String)cur.value;
            if (this.m_labels.get((Object)label) <= this.l_cutoff) continue;
            this.s_model.addLabel(label);
        }
        this.s_model.initLabelArray();
        for (String type : this.m_features.keySet()) {
            ObjectIntOpenHashMap<String> map = this.m_features.get(type);
            for (ObjectCursor cur : map.keys()) {
                String value = (String)cur.value;
                if (map.get((Object)value) <= this.f_cutoff) continue;
                this.s_model.addFeature(type, value);
            }
        }
    }

    public static Pair<String, StringFeatureVector> toInstance(String line, boolean hasWeight) {
        String[] tmp = line.split(" ");
        String label = tmp[0];
        StringFeatureVector vector = new StringFeatureVector(hasWeight);
        int size = tmp.length;
        for (int i = 1; i < size; ++i) {
            vector.addFeature(tmp[i]);
        }
        return new Pair<String, StringFeatureVector>(label, vector);
    }
}

