/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.train;

import com.googlecode.clearnlp.classification.algorithm.AbstractAlgorithm;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Trainer {
    private AbstractTrainSpace t_space;
    private AbstractAlgorithm a_algorithm;
    private volatile AbstractModel m_model;

    public Trainer(AbstractTrainSpace space, AbstractAlgorithm algorithm, int numThreads) {
        this.t_space = space;
        this.a_algorithm = algorithm;
        this.m_model = space.getModel();
        System.out.println("Training:");
        this.m_model.initWeightVector();
        if (space.isBinaryLabel()) {
            this.trainBinary();
        } else {
            this.trainMulti(numThreads);
        }
    }

    private void trainBinary() {
        double[] weights = this.a_algorithm.getWeight(this.t_space, 0);
        this.m_model.copyWeightVector(weights);
    }

    private void trainMulti(int numThreads) {
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        int size = this.t_space.getLabelSize();
        for (int currLabel = 0; currLabel < size; ++currLabel) {
            executor.execute(new TrainTask(currLabel));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class TrainTask
    implements Runnable {
        int curr_label;

        public TrainTask(int currLabel) {
            this.curr_label = currLabel;
        }

        @Override
        public void run() {
            double[] weights = Trainer.this.a_algorithm.getWeight(Trainer.this.t_space, this.curr_label);
            Trainer.this.m_model.copyWeightVector(this.curr_label, weights);
        }
    }
}

