/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.vector;

import com.carrotsearch.hppc.IntArrayList;
import com.googlecode.clearnlp.classification.vector.AbstractFeatureVector;

public class SparseFeatureVector
extends AbstractFeatureVector {
    private IntArrayList i_indices;

    public SparseFeatureVector() {
    }

    public SparseFeatureVector(boolean hasWeight) {
        super(hasWeight);
    }

    @Override
    protected void init() {
        this.i_indices = new IntArrayList();
    }

    public void addFeature(int index) {
        this.i_indices.add(index);
    }

    public void addFeature(int index, double weight) {
        this.i_indices.add(index);
        this.d_weights.add(weight);
    }

    public void addFeatures(int[] indices) {
        this.i_indices.add(indices);
    }

    public void addFeatures(int[] indices, double[] weights) {
        this.i_indices.add(indices);
        this.d_weights.add(weights);
    }

    public void addFeature(String feature) {
        if (this.b_weight) {
            String[] tmp = feature.split(":");
            this.i_indices.add(Integer.parseInt(tmp[0]));
            this.d_weights.add(Double.parseDouble(tmp[1]));
        } else {
            this.i_indices.add(Integer.parseInt(feature));
        }
    }

    public int getIndex(int index) {
        return this.i_indices.get(index);
    }

    public int[] getIndices() {
        return this.i_indices.toArray();
    }

    public int size() {
        return this.i_indices.size();
    }

    public void trimToSize() {
        this.i_indices.trimToSize();
        if (this.b_weight) {
            this.d_weights.trimToSize();
        }
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        int size = this.i_indices.size();
        for (int i = 0; i < size; ++i) {
            build.append(" ");
            build.append(this.i_indices.get(i));
            if (!this.b_weight) continue;
            build.append(":");
            build.append(this.d_weights.get(i));
        }
        return build.toString().substring(" ".length());
    }
}

