/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.vector;

import com.carrotsearch.hppc.DoubleArrayList;
import com.googlecode.clearnlp.classification.vector.AbstractFeatureVector;
import java.util.ArrayList;
import java.util.List;

public class StringFeatureVector
extends AbstractFeatureVector {
    private List<String> s_types;
    private List<String> s_values;

    public StringFeatureVector() {
    }

    public StringFeatureVector(boolean hasWeight) {
        super(hasWeight);
    }

    @Override
    protected void init() {
        this.s_types = new ArrayList<String>();
        this.s_values = new ArrayList<String>();
    }

    public StringFeatureVector clone() {
        StringFeatureVector copy = new StringFeatureVector(this.b_weight);
        copy.s_types = new ArrayList<String>(this.s_types);
        copy.s_values = new ArrayList<String>(this.s_values);
        if (this.b_weight) {
            copy.d_weights = this.d_weights.clone();
        }
        return copy;
    }

    public void addFeature(String type, String value) {
        this.s_types.add(type);
        this.s_values.add(value);
    }

    public void addFeature(String type, String value, double weight) {
        this.s_types.add(type);
        this.s_values.add(value);
        this.d_weights.add(weight);
    }

    public void addFeature(String feature) {
        int idx0 = feature.indexOf(":");
        this.s_types.add(feature.substring(0, idx0));
        if (this.b_weight) {
            int idx1 = feature.lastIndexOf(":");
            this.s_values.add(feature.substring(idx0 + 1, idx1));
            this.d_weights.add(Double.parseDouble(feature.substring(idx1 + 1)));
        } else {
            this.s_values.add(feature.substring(idx0 + 1));
        }
    }

    public void addFeatures(StringFeatureVector vector) {
        List<String> types = vector.s_types;
        List<String> values = vector.s_values;
        DoubleArrayList weights = vector.d_weights;
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            this.s_types.add(types.get(i));
            this.s_values.add(values.get(i));
            if (weights == null) continue;
            this.d_weights.add(weights.get(i));
        }
    }

    public String getType(int index) {
        return this.s_types.get(index);
    }

    public String getValue(int index) {
        return this.s_values.get(index);
    }

    public int size() {
        return this.s_types.size();
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        int size = this.s_types.size();
        for (int i = 0; i < size; ++i) {
            build.append(" ");
            build.append(this.s_types.get(i));
            build.append(":");
            build.append(this.s_values.get(i));
            if (!this.b_weight) continue;
            build.append(":");
            build.append(this.d_weights.get(i));
        }
        return build.toString().substring(" ".length());
    }
}

