/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component.srl;

import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.component.AbstractStatisticalComponent;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CPredIdentifier
extends AbstractStatisticalComponent {
    private final String ENTRY_CONFIGURATION = "pred_CONFIGURATION";
    private final String ENTRY_FEATURE = "pred_FEATURE";
    private final String ENTRY_MODEL = "pred_MODEL";
    protected Boolean[] g_preds;
    protected int i_pred;

    public CPredIdentifier(JointFtrXml[] xmls) {
        super(xmls);
    }

    public CPredIdentifier(JointFtrXml[] xmls, StringTrainSpace[] spaces, Object[] lexica) {
        super(xmls, spaces, lexica);
    }

    public CPredIdentifier(JointFtrXml[] xmls, StringModel[] models, Object[] lexica) {
        super(xmls, models, lexica);
    }

    public CPredIdentifier(ZipInputStream in) {
        super(in);
    }

    @Override
    protected void initLexia(Object[] lexica) {
    }

    @Override
    public void loadModels(ZipInputStream zin) {
        int fLen = "pred_FEATURE".length();
        int mLen = "pred_MODEL".length();
        this.f_xmls = new JointFtrXml[1];
        this.s_models = null;
        try {
            ZipEntry zEntry;
            while ((zEntry = zin.getNextEntry()) != null) {
                String entry = zEntry.getName();
                if (entry.equals("pred_CONFIGURATION")) {
                    this.loadDefaultConfiguration(zin);
                    continue;
                }
                if (entry.startsWith("pred_FEATURE")) {
                    this.loadFeatureTemplates(zin, Integer.parseInt(entry.substring(fLen)));
                    continue;
                }
                if (!entry.startsWith("pred_MODEL")) continue;
                this.loadStatisticalModels(zin, Integer.parseInt(entry.substring(mLen)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveModels(ZipOutputStream zout) {
        try {
            this.saveDefaultConfiguration(zout, "pred_CONFIGURATION");
            this.saveFeatureTemplates(zout, "pred_FEATURE");
            this.saveStatisticalModels(zout, "pred_MODEL");
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object[] getLexica() {
        return null;
    }

    @Override
    public void countAccuracy(int[] counts) {
        int pTotal = 0;
        int rTotal = 0;
        int correct = 0;
        for (int i = 1; i < this.t_size; ++i) {
            DEPNode node = this.d_tree.get(i);
            if (node.getFeat("pb") != null) {
                ++pTotal;
                if (this.g_preds[i].booleanValue()) {
                    ++correct;
                }
            }
            if (!this.g_preds[i].booleanValue()) continue;
            ++rTotal;
        }
        counts[0] = counts[0] + correct;
        counts[1] = counts[1] + pTotal;
        counts[2] = counts[2] + rTotal;
    }

    @Override
    public void process(DEPTree tree) {
        this.init(tree);
        this.identify();
    }

    protected void init(DEPTree tree) {
        this.d_tree = tree;
        this.t_size = tree.size();
        if (this.i_flag != 2) {
            this.g_preds = tree.getPredicates();
        }
        tree.clearPredicates();
        tree.setDependents();
    }

    protected void identify() {
        this.i_pred = 1;
        while (this.i_pred < this.t_size) {
            String label;
            DEPNode pred = this.d_tree.get(this.i_pred);
            if (this.f_xmls[0].isPredicate(pred) && (label = this.getLabel()).equals(AbstractModel.LABEL_TRUE)) {
                pred.addFeat("pb", pred.lemma + ".XX");
            }
            ++this.i_pred;
        }
    }

    protected String getLabel() {
        StringFeatureVector vector = this.getFeatureVector(this.f_xmls[0]);
        String label = null;
        if (this.i_flag == 1) {
            label = this.getGoldLabel();
            this.s_spaces[0].addInstance(label, vector);
        } else if (this.i_flag == 2 || this.i_flag == 4) {
            label = this.getAutoLabel(vector);
        }
        return label;
    }

    private String getGoldLabel() {
        return this.g_preds[this.i_pred] != false ? AbstractModel.LABEL_TRUE : AbstractModel.LABEL_FALSE;
    }

    private String getAutoLabel(StringFeatureVector vector) {
        StringPrediction p = this.s_models[0].predictBest(vector);
        return p.label;
    }

    @Override
    protected String getField(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("f")) {
            return node.form;
        }
        if (token.isField("m")) {
            return node.lemma;
        }
        if (token.isField("p")) {
            return node.pos;
        }
        if (token.isField("d")) {
            return node.getLabel();
        }
        Matcher m = SRLFtrXml.P_FEAT.matcher(token.field);
        if (m.find()) {
            return node.getFeat(m.group(1));
        }
        return null;
    }

    @Override
    protected String[] getFields(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("ds")) {
            return this.getDeprelSet(node.getDependents());
        }
        return null;
    }

    private String[] getDeprelSet(List<DEPArc> deps) {
        if (deps.isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (DEPArc arc : deps) {
            set.add(arc.getLabel());
        }
        String[] fields = new String[set.size()];
        set.toArray(fields);
        return fields;
    }

    private DEPNode getNode(FtrToken token) {
        DEPNode node = this.getNodeAux(token);
        if (node == null) {
            return null;
        }
        if (token.relation != null) {
            if (token.isRelation("h")) {
                node = node.getHead();
            } else if (token.isRelation("lmd")) {
                node = node.getLeftMostDependent();
            } else if (token.isRelation("rmd")) {
                node = node.getRightMostDependent();
            }
        }
        return node;
    }

    private DEPNode getNodeAux(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_pred);
        }
        int cIndex = this.i_pred + token.offset;
        if (0 < cIndex && cIndex < this.d_tree.size()) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }
}

