/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;

public class DemoPOSTagger {
    final String language = "en";

    public DemoPOSTagger(String dictionaryFile, String posModelFile, String inputFile, String outputFile) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", dictionaryFile);
        Pair<POSTagger[], Double> taggers = EngineGetter.getPOSTaggers(posModelFile);
        String sentence = "I'd like to meet Mr. Choi.";
        this.tag(tokenizer, taggers, sentence);
        this.tag(tokenizer, taggers, UTInput.createBufferedFileReader(inputFile), UTOutput.createPrintBufferedFileStream(outputFile));
    }

    public void tag(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, String sentence) {
        Object[] nodes = EngineProcess.getPOSNodes(tokenizer, taggers, sentence);
        System.out.println(UTArray.join(nodes, "\n") + "\n");
    }

    public void tag(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, BufferedReader reader, PrintStream fout) {
        AbstractSegmenter segmenter = EngineGetter.getSegmenter("en", tokenizer);
        for (List<String> tokens : segmenter.getSentences(reader)) {
            Object[] nodes = EngineProcess.getPOSNodes(taggers, tokens);
            fout.println(UTArray.join(nodes, "\n") + "\n");
        }
        fout.close();
    }

    public static void main(String[] args) {
        String dictionaryFile = args[0];
        String posModelFile = args[1];
        String inputFile = args[2];
        String outputFile = args[3];
        try {
            new DemoPOSTagger(dictionaryFile, posModelFile, inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

