/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.feature.xml.FtrToken;

public class FtrTemplate {
    private static final String TYPE_SET = "s";
    private static final String TYPE_BOOLEAN = "b";
    public String type;
    public FtrToken[] tokens;
    public boolean visible;
    public String note;

    public FtrTemplate(String type, int n, boolean visible, String note) {
        this.type = type;
        this.visible = visible;
        this.note = note;
        this.tokens = new FtrToken[n];
    }

    public void setFtrToken(int index, FtrToken token) {
        this.tokens[index] = token;
    }

    public boolean isSetFeature() {
        return this.type.startsWith(TYPE_SET);
    }

    public boolean isBooleanFeature() {
        return this.type.startsWith(TYPE_BOOLEAN);
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        if (this.isSetFeature()) {
            this.toStringAux(build, "t", TYPE_SET);
            build.append(" ");
        } else if (this.isBooleanFeature()) {
            this.toStringAux(build, "t", TYPE_BOOLEAN);
            build.append(" ");
        }
        this.toStringAux(build, "n", Integer.toString(this.tokens.length));
        for (int i = 0; i < this.tokens.length; ++i) {
            build.append(" ");
            this.toStringAux(build, "f" + i, this.tokens[i].toString());
        }
        if (!this.visible) {
            build.append(" ");
            this.toStringAux(build, "visible", "false");
        }
        if (!this.note.isEmpty()) {
            build.append(" ");
            this.toStringAux(build, "note", this.note);
        }
        return build.toString();
    }

    private void toStringAux(StringBuilder build, String field, String value) {
        build.append(field);
        build.append("=\"");
        build.append(value);
        build.append("\"");
    }
}

