/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.headrule;

import com.googlecode.clearnlp.headrule.HeadTagSet;

public class HeadRule {
    public static final String DELIM_TAGSETS = ";";
    public static final String DIR_LEFT_TO_RIGHT = "l";
    public static final String DIR_RIGHT_TO_LEFT = "r";
    protected boolean b_r2l;
    protected HeadTagSet[] a_tagSets;

    public HeadRule(String dir, String[][] headTagSets) {
        this.b_r2l = dir.equals(DIR_RIGHT_TO_LEFT);
        this.a_tagSets = new HeadTagSet[headTagSets.length];
        for (int i = 0; i < this.a_tagSets.length; ++i) {
            this.a_tagSets[i] = new HeadTagSet(headTagSets[i]);
        }
    }

    public boolean isRightToLeft() {
        return this.b_r2l;
    }

    public HeadTagSet[] getHeadTags() {
        return this.a_tagSets;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        for (HeadTagSet tag : this.a_tagSets) {
            build.append(DELIM_TAGSETS);
            build.append(tag.toString());
        }
        return build.substring(DELIM_TAGSETS.length());
    }
}

