/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.pos;

public class POSNode {
    public String form;
    public String simplifiedForm;
    public String lowerSimplifiedForm;
    public String pos;
    public String lemma;

    public POSNode() {
        this.init("_N_", "_N_", "_N_");
    }

    public POSNode(String form) {
        this.init(form, "_N_", "_N_");
    }

    public POSNode(String form, String pos) {
        this.init(form, pos, "_N_");
    }

    public POSNode(String form, String pos, String lemma) {
        this.init(form, pos, lemma);
    }

    public void init(String form, String pos, String lemma) {
        this.form = form;
        this.pos = pos;
        this.lemma = lemma;
        this.simplifiedForm = "_N_";
        this.lowerSimplifiedForm = "_N_";
    }

    public boolean isForm(String form) {
        return this.form.equals(form);
    }

    public boolean isSimplifiedForm(String form) {
        return this.simplifiedForm.equals(form);
    }

    public boolean isPos(String pos) {
        return this.pos.equals(pos);
    }

    public boolean isLemma(String lemma) {
        return this.lemma.equals(lemma);
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.form);
        build.append("\t");
        build.append(this.pos);
        return build.toString();
    }

    public String toString(boolean includeLemma) {
        StringBuilder build = new StringBuilder();
        build.append(this.form);
        build.append("\t");
        build.append(this.pos);
        if (includeLemma) {
            build.append("\t");
            build.append(this.lemma);
        }
        return build.toString();
    }
}

