/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.googlecode.clearnlp.reader.AbstractReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractColumnReader<T>
extends AbstractReader<T> {
    public static final String BLANK_COLUMN = "_";
    public static final String DELIM_COLUMN = "\t";
    public static final String DELIM_SENTENCE = "\n";
    public static final String FIELD_ID = "id";
    public static final String FIELD_FORM = "form";
    public static final String FIELD_LEMMA = "lemma";
    public static final String FIELD_POS = "pos";
    public static final String FIELD_FEATS = "feats";
    public static final String FIELD_HEADID = "headId";
    public static final String FIELD_DEPREL = "deprel";
    public static final String FIELD_SHEADS = "sheads";
    public static final String FIELD_XHEADS = "xheads";
    public static final String FIELD_NAMENT = "nament";
    public static final String FIELD_COREF = "coref";
    private final Pattern P_COLUMN = Pattern.compile("\t");

    protected List<String[]> readLines() throws Exception {
        String line;
        while ((line = this.f_in.readLine()) != null && this.isSkip(line)) {
        }
        if (line == null) {
            this.close();
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(this.P_COLUMN.split(line));
        while ((line = this.f_in.readLine()) != null) {
            if (this.isSkip(line)) {
                return list;
            }
            list.add(line.split(DELIM_COLUMN));
        }
        return list;
    }

    protected boolean isSkip(String line) {
        return line.trim().isEmpty();
    }
}

