/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.classification.model.SparseModel;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.classification.train.SparseTrainSpace;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.PrintStream;
import org.kohsuke.args4j.Option;

public class LiblinearPredict
extends AbstractRun {
    @Option(name="-i", usage="the input file (input; required)", required=true, metaVar="<filename>")
    private String s_testFile;
    @Option(name="-o", usage="the output file (output; required)", required=true, metaVar="<filename>")
    private String s_outputFile;
    @Option(name="-m", usage="the model file (input; required)", required=true, metaVar="<filename>")
    private String s_modelFile;
    @Option(name="-v", usage="the type of vector space (default: 1)\n0: sparse vector space\n1: string vector space\n", required=false, metaVar="<byte>")
    private byte i_vectorType = 1;

    public LiblinearPredict() {
    }

    public LiblinearPredict(String[] args) {
        this.initArgs(args);
        try {
            this.predict(this.s_testFile, this.s_outputFile, this.s_modelFile, this.i_vectorType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void predict(String testFile, String outputFile, String modelFile, byte vectorType) throws Exception {
        String line;
        BufferedReader fin = UTInput.createBufferedFileReader(testFile);
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        BufferedReader reader = UTInput.createBufferedGZipFileReader(modelFile);
        SparseModel pModel = null;
        StringModel sModel = null;
        switch (vectorType) {
            case 0: {
                pModel = new SparseModel(reader);
                break;
            }
            case 1: {
                sModel = new StringModel(reader);
            }
        }
        reader.close();
        boolean hasWeight = AbstractTrainSpace.hasWeight(vectorType, testFile);
        int correct = 0;
        int total = 0;
        StringPrediction r = null;
        String label = null;
        System.out.print("Predicting");
        while ((line = fin.readLine()) != null) {
            if (vectorType == 0) {
                Pair<String, SparseFeatureVector> sp = SparseTrainSpace.toInstance(line, hasWeight);
                r = pModel.predictBest((SparseFeatureVector)sp.o2);
                label = (String)sp.o1;
            } else {
                Pair<String, StringFeatureVector> ss = StringTrainSpace.toInstance(line, hasWeight);
                r = sModel.predictBest((StringFeatureVector)ss.o2);
                label = (String)ss.o1;
            }
            fout.println(r.label + " " + r.score);
            if (r.label.equals(label)) {
                ++correct;
            }
            if (++total % 10000 != 0) continue;
            System.out.print(".");
        }
        fin.close();
        fout.close();
        System.out.println();
        System.out.printf("Accuracy = %7.4f (%d/%d)\n", 100.0 * (double)correct / (double)total, correct, total);
    }

    public static void main(String[] args) {
        new LiblinearPredict(args);
    }
}

