/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.classification.algorithm.AbstractAlgorithm;
import com.googlecode.clearnlp.classification.algorithm.LiblinearL2LR;
import com.googlecode.clearnlp.classification.algorithm.LiblinearL2SV;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.classification.train.SparseTrainSpace;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.train.Trainer;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.PrintStream;
import org.kohsuke.args4j.Option;

public class LiblinearTrain
extends AbstractRun {
    @Option(name="-i", usage="the training file (input; required)", required=true, metaVar="<filename>")
    private String s_trainFile;
    @Option(name="-m", usage="the model file (output; required)", required=true, metaVar="<filename>")
    private String s_modelFile;
    @Option(name="-nl", usage="label frequency cutoff (default: 0)\nexclusive, string vector space only", required=false, metaVar="<integer>")
    private int i_labelCutoff = 0;
    @Option(name="-nf", usage="feature frequency cutoff (default: 0)\nexclusive, string vector space only", required=false, metaVar="<integer>")
    private int i_featureCutoff = 0;
    @Option(name="-nt", usage="the number of threads to be used (default: 1)", required=false, metaVar="<integer>")
    private int i_numThreads = 1;
    @Option(name="-v", usage="the type of vector space (default: 1)\n0: sparse vector space\n1: string vector space\n", required=false, metaVar="<byte>")
    private byte i_vectorType = 1;
    @Option(name="-s", usage="the type of solver (default: 0)\n0: L2-regularized L1-loss support vector classification (dual)\n1: L2-regularized L2-loss support vector classification (dual)\n2: L2-regularized logistic regression (dual)", required=false, metaVar="<byte>")
    private byte i_solver = 0;
    @Option(name="-c", usage="the cost (default: 0.1)", required=false, metaVar="<double>")
    private double d_cost = 0.1;
    @Option(name="-e", usage="the tolerance of termination criterion (default: 0.1)", required=false, metaVar="<double>")
    private double d_eps = 0.1;
    @Option(name="-b", usage="the bias (default: 0)", required=false, metaVar="<double>")
    private double d_bias = 0.0;

    public LiblinearTrain() {
    }

    public LiblinearTrain(String[] args) {
        this.initArgs(args);
        try {
            this.train(this.s_trainFile, this.s_modelFile, this.i_vectorType, this.i_labelCutoff, this.i_featureCutoff, this.i_numThreads, this.i_solver, this.d_cost, this.d_eps, this.d_bias);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void train(String trainFile, String modelFile, byte vectorType, int labelCutoff, int featureCutoff, int numThreads, byte solver, double cost, double eps, double bias) throws Exception {
        AbstractTrainSpace space = null;
        boolean hasWeight = AbstractTrainSpace.hasWeight(vectorType, trainFile);
        switch (vectorType) {
            case 0: {
                space = new SparseTrainSpace(hasWeight);
                break;
            }
            case 1: {
                space = new StringTrainSpace(hasWeight, labelCutoff, featureCutoff);
            }
        }
        space.readInstances(UTInput.createBufferedFileReader(trainFile));
        space.build();
        AbstractModel model = LiblinearTrain.getModel(space, numThreads, solver, cost, eps, bias);
        PrintStream fout = UTOutput.createPrintBufferedGZipFileStream(modelFile);
        model.setSolver(solver);
        model.save(fout);
        fout.close();
    }

    public static AbstractModel getModel(AbstractTrainSpace space, int numThreads, byte solver, double cost, double eps, double bias) {
        AbstractAlgorithm algorithm = null;
        switch (solver) {
            case 0: {
                algorithm = new LiblinearL2SV(1, cost, eps, bias);
                break;
            }
            case 1: {
                algorithm = new LiblinearL2SV(2, cost, eps, bias);
                break;
            }
            case 2: {
                algorithm = new LiblinearL2LR(cost, eps, bias);
            }
        }
        new Trainer(space, algorithm, numThreads);
        return space.getModel();
    }

    public static void main(String[] args) {
        new LiblinearTrain(args);
    }
}

