/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.feature.xml.POSFtrXml;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.run.POSPredict;
import com.googlecode.clearnlp.run.POSTrain;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.File;
import java.io.FileInputStream;
import org.w3c.dom.Element;

public class POSGenerate
extends POSTrain {
    public POSGenerate(String[] args) throws Exception {
        this.initArgs(args);
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(this.s_configXml));
        POSReader reader = (POSReader)this.getReader((Element)eConfig).o1;
        POSFtrXml xml = new POSFtrXml(new FileInputStream(this.s_featureXml));
        String[] trnFiles = UTFile.getSortedFileList(this.s_trainDir);
        Pair<Object, Double> taggers = new Pair<Object, Double>(null, this.d_threshold);
        int size = trnFiles.length;
        POSPredict p = new POSPredict();
        for (int devId = 0; devId < size; ++devId) {
            String devFile = trnFiles[devId];
            devFile = devFile.substring(devFile.lastIndexOf(File.separator) + 1);
            System.out.println("Cross validation: " + devFile);
            taggers.o1 = this.i_flag == 2 ? this.getTrainedTaggers(eConfig, reader, xml, trnFiles, devId) : new POSTagger[]{this.getTrainedTagger(eConfig, reader, xml, trnFiles, devId, 1)};
            p.predict(taggers, reader, trnFiles[devId], this.s_trainDir + File.separator + devFile + ".tagged");
        }
    }

    public static void main(String[] args) {
        try {
            new POSGenerate(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

