/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.segmentation;

import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EnglishSegmenter
extends AbstractSegmenter {
    protected final Pattern P_TERMINAL_PUNCTUATION = Pattern.compile("^(\\.|\\?|\\!)+$");
    protected final String[] L_BRACKETS = new String[]{"\"", "(", "{", "["};
    protected final String[] R_BRACKETS = new String[]{"\"", ")", "}", "]"};

    public EnglishSegmenter(AbstractTokenizer tokenizer) {
        super(tokenizer);
    }

    @Override
    public List<List<String>> getSentences(BufferedReader fin) {
        ArrayList<List<String>> sentences = new ArrayList<List<String>>();
        List<String> tokens = this.g_tokenizer.getTokens(fin);
        int[] brackets = new int[this.R_BRACKETS.length];
        int size = tokens.size();
        boolean isTerminal = false;
        int bIdx = 0;
        for (int i = 0; i < size; ++i) {
            String curr = tokens.get(i);
            this.countBrackets(curr, brackets);
            if (!isTerminal && !this.P_TERMINAL_PUNCTUATION.matcher(curr).find()) continue;
            if (i + 1 < size && this.isFollowedByBracket(tokens.get(i + 1), brackets)) {
                isTerminal = true;
                continue;
            }
            int n = bIdx;
            bIdx = i + 1;
            sentences.add(tokens.subList(n, bIdx));
            isTerminal = false;
        }
        return sentences;
    }

    private void countBrackets(String str, int[] brackets) {
        if (str.equals("\"")) {
            brackets[0] = brackets[0] + (brackets[0] == 0 ? 1 : -1);
        } else {
            int size = brackets.length;
            for (int i = 1; i < size; ++i) {
                if (str.equals(this.L_BRACKETS[i])) {
                    int n = i;
                    brackets[n] = brackets[n] + 1;
                    continue;
                }
                if (!str.equals(this.R_BRACKETS[i])) continue;
                int n = i;
                brackets[n] = brackets[n] - 1;
            }
        }
    }

    private boolean isFollowedByBracket(String str, int[] brackets) {
        int size = this.R_BRACKETS.length;
        for (int i = 0; i < size; ++i) {
            if (brackets[i] <= 0 || !str.equals(this.R_BRACKETS[i])) continue;
            return true;
        }
        return false;
    }
}

