/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.tools;

import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.tools.TRMenuBar;
import com.googlecode.clearnlp.tools.TRTablePane;
import com.googlecode.clearnlp.tools.TRTreePane;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class Trinity
extends JFrame {
    private static final long serialVersionUID = -5371383601723946523L;
    private TRMenuBar mn_bar = new TRMenuBar(new TRMenuListener());
    private JComboBox cb_trees;
    private TRTreePane pn_trees;
    private TRTablePane pn_table;
    private List<DEPTree> l_trees;
    private int i_currTree;
    private boolean b_update;
    private String s_outputFile;

    public Trinity(StringIntPair[] tags) {
        this.setJMenuBar(this.mn_bar);
        this.setLayout(new BorderLayout());
        this.cb_trees = this.getCBTrees();
        this.add((Component)this.cb_trees, "North");
        this.pn_trees = new TRTreePane();
        this.add((Component)new JScrollPane(this.pn_trees), "Center");
        this.pn_table = new TRTablePane(new JTableModelListener(), tags);
        this.add((Component)new JScrollPane(this.pn_table), "South");
        this.setVisible(true);
        this.setBounds(0, 0, 800, 500);
        this.setBackground(Color.WHITE);
        this.setDefaultCloseOperation(3);
    }

    public void open(String inputFile, String outputFile) {
        this.l_trees = this.getTrees(inputFile);
        this.resetCBTrees(this.l_trees);
        this.s_outputFile = outputFile;
    }

    private List<DEPTree> getTrees(String inputFile) {
        DEPTree tree;
        JointReader reader = new JointReader(0, 1, 2, 3, 4, 5, 6);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        ArrayList<DEPTree> trees = new ArrayList<DEPTree>();
        while ((tree = reader.next()) != null) {
            trees.add(tree);
        }
        reader.close();
        return trees;
    }

    private JComboBox getCBTrees() {
        JComboBox cb = new JComboBox();
        cb.addActionListener(new TRComboBoxListener());
        return cb;
    }

    private void resetCBTrees(List<DEPTree> trees) {
        int size = trees.size();
        this.cb_trees.removeAllItems();
        for (int i = 0; i < size; ++i) {
            this.cb_trees.addItem(Integer.toString(i) + " - " + trees.get(i).toStringRaw());
        }
        this.cb_trees.revalidate();
    }

    protected void selectTree(int index) {
        DEPTree tree = this.l_trees.get(index);
        this.i_currTree = index;
        this.b_update = false;
        this.pn_trees.init(tree);
        this.pn_table.init(tree);
        this.b_update = true;
    }

    public void saveTrees(String outputFile) {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        for (DEPTree tree : this.l_trees) {
            fout.println(tree.toStringDEP() + "\n");
        }
        fout.close();
    }

    private void menuSave() {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(this.s_outputFile);
        for (DEPTree tree : this.l_trees) {
            fout.println(tree.toStringDEP() + "\n");
        }
        fout.close();
    }

    private void menuPrev() {
        if (this.i_currTree > 0) {
            --this.i_currTree;
        }
        this.cb_trees.setSelectedIndex(this.i_currTree);
    }

    private void menuNext() {
        if (this.i_currTree < this.l_trees.size() - 1) {
            ++this.i_currTree;
        }
        this.cb_trees.setSelectedIndex(this.i_currTree);
    }

    public static void main(String[] args) {
        String posFile = args[0];
        String depFile = args[1];
        String inputFile = args[2];
        String outputFile = args[3];
        StringIntPair[] ps = new StringIntPair[]{new StringIntPair(posFile, 2), new StringIntPair(depFile, 4)};
        Trinity tr = new Trinity(ps);
        tr.open(inputFile, outputFile);
    }

    private class JTableModelListener
    implements TableModelListener {
        private JTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (Trinity.this.b_update) {
                int column = e.getColumn();
                int row = e.getLastRow();
                Trinity.this.pn_table.updateTree(row, column);
                Trinity.this.pn_trees.updateTree();
            }
        }
    }

    private class TRComboBoxListener
    implements ActionListener {
        private TRComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Trinity.this.selectTree(cb.getSelectedIndex());
        }
    }

    private class TRMenuListener
    implements ActionListener {
        private TRMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ((Trinity)Trinity.this).mn_bar.nvPrev) {
                Trinity.this.menuPrev();
            } else if (e.getSource() == ((Trinity)Trinity.this).mn_bar.nvNext) {
                Trinity.this.menuNext();
            } else if (e.getSource() == ((Trinity)Trinity.this).mn_bar.fileSave) {
                Trinity.this.menuSave();
            }
        }
    }
}

