/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.jdl.data.base.JdlConnection;
import org.apache.ctakes.jdl.data.loader.Loader;
import org.apache.ctakes.jdl.schema.xdl.CsvLoadType;

public class CsvLoader
extends Loader {
    private CSVParser parser;
    private CsvLoadType loader;
    static final char DISABLED = '\ufffe';
    static final Log log = LogFactory.getLog(CsvLoader.class);
    private Map<String, Format> formatMap;

    public CsvLoader(CsvLoadType loader, File file) throws FileNotFoundException {
        FileInputStream inputStrem = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(inputStrem);
        char delimiter = CharUtils.toChar((String)loader.getDelimiter());
        char encapsulator = loader.getEncapsulator() == null || loader.getEncapsulator().length() == 0 ? CSVStrategy.ENCAPSULATOR_DISABLED : CharUtils.toChar((String)loader.getEncapsulator());
        log.info((Object)String.format("delimiter %d encapsulator %d", delimiter, (int)encapsulator));
        CSVStrategy strategy = new CSVStrategy(delimiter, encapsulator, CSVStrategy.COMMENTS_DISABLED, CSVStrategy.ESCAPE_DISABLED, true, true, false, true);
        this.parser = new CSVParser((Reader)reader, strategy);
        this.loader = loader;
        this.formatMap = new HashMap<String, Format>();
        try {
            for (CsvLoadType.Column col : loader.getColumn()) {
                if (col.getFormat() == null || col.getFormat().length() <= 0) continue;
                Class<?> cf = Class.forName(col.getFormat());
                Constructor<?> ccf = cf.getConstructor(String.class);
                this.formatMap.put(col.getName(), (Format)ccf.newInstance(col.getPattern()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("oops", e);
        }
    }

    public final String getSqlInsert(CsvLoadType loader) {
        String query = "insert into " + loader.getTable() + " (";
        String values = ") values (";
        for (CsvLoadType.Column column : loader.getColumn()) {
            if (!BooleanUtils.isNotTrue((Boolean)column.isSkip())) continue;
            query = query + column.getName() + ",";
            values = values + "?,";
        }
        return StringUtils.removeEnd((String)query, (String)",") + StringUtils.removeEnd((String)values, (String)",") + ")";
    }

    @Override
    public final void dataInsert(JdlConnection jdlConnection) {
        String sql = this.getSqlInsert(this.loader);
        if (log.isInfoEnabled()) {
            log.info((Object)sql);
        }
        BigInteger ncommit = this.loader.getCommit();
        int rs = this.loader.getSkip() == null ? 0 : this.loader.getSkip().intValue();
        Statement preparedStatement = null;
        try {
            jdlConnection.setAutoCommit(false);
            preparedStatement = jdlConnection.getOpenConnection().prepareStatement(sql);
            boolean leftoversToCommit = false;
            String[] row = null;
            int r = 0;
            while ((row = this.parser.getLine()) != null) {
                if (r < rs) {
                    ++r;
                } else {
                    ++r;
                    try {
                        int cs = 0;
                        int ce = 0;
                        int c = 0;
                        for (CsvLoadType.Column column : this.loader.getColumn()) {
                            if (BooleanUtils.isTrue((Boolean)column.isSkip())) {
                                ++cs;
                                continue;
                            }
                            ++c;
                            Object value = column.getConstant();
                            ++ce;
                            if (value == null) {
                                if (column.getSeq() != null) {
                                    value = r + column.getSeq().intValue();
                                } else {
                                    value = row[c + cs - ce];
                                    --ce;
                                }
                            }
                            if (value == null || value instanceof String && ((String)value).length() == 0) {
                                preparedStatement.setObject(c, null);
                                continue;
                            }
                            if (this.formatMap.containsKey(column.getName())) {
                                try {
                                    preparedStatement.setObject(c, this.formatMap.get(column.getName()).parseObject((String)value));
                                    continue;
                                }
                                catch (Exception e) {
                                    System.err.println("Could not format '" + value + "' for column " + column.getName() + " on line " + r);
                                    e.printStackTrace(System.err);
                                    throw new RuntimeException(e);
                                }
                            }
                            preparedStatement.setObject(c, value);
                        }
                        preparedStatement.addBatch();
                        leftoversToCommit = true;
                        if (r % ((Number)ncommit).intValue() == 0) {
                            preparedStatement.executeBatch();
                            jdlConnection.commitConnection();
                            leftoversToCommit = false;
                            log.info((Object)("inserted " + ((Number)ncommit).intValue() + " rows"));
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (row != null) continue;
            }
            if (leftoversToCommit) {
                preparedStatement.executeBatch();
                jdlConnection.commitConnection();
                leftoversToCommit = false;
            }
            log.info((Object)("inserted " + (r - rs) + " rows total"));
        }
        catch (InstantiationException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

