/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.loader;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.lang.StringUtils;
import org.apache.ctakes.jdl.data.base.JdlConnection;
import org.apache.ctakes.jdl.data.loader.Loader;
import org.apache.ctakes.jdl.data.xml.DomUtil;
import org.apache.ctakes.jdl.schema.xdl.XmlLoadType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlLoader
extends Loader {
    private JXPathContext context;
    private XmlLoadType loader;

    public XmlLoader(XmlLoadType loader, Document document) {
        this.context = JXPathContext.newContext((Object)document);
        this.loader = loader;
    }

    public final String getSqlInsert(XmlLoadType loader) {
        String query = "insert into " + loader.getTable() + " (";
        String values = ") values (";
        for (XmlLoadType.Column column : loader.getColumn()) {
            query = query + column.getName() + ",";
            values = values + "?,";
        }
        return StringUtils.removeEnd((String)query, (String)",") + StringUtils.removeEnd((String)values, (String)",") + ")";
    }

    @Override
    public final void dataInsert(JdlConnection jdlConnection) {
        String sql = this.getSqlInsert(this.loader);
        BigInteger ncommit = this.loader.getCommit();
        int r = 0;
        try {
            Iterator iterator = this.context.iteratePointers(this.loader.getXroot());
            while (iterator.hasNext()) {
                ++r;
                NodePointer pointer = (NodePointer)iterator.next();
                Node node = (Node)pointer.getNode();
                JXPathContext context = JXPathContext.newContext((Object)DomUtil.nodeToDocument(node));
                try {
                    int c = 0;
                    PreparedStatement preparedStatement = jdlConnection.getOpenConnection().prepareStatement(sql);
                    if (ncommit == null) {
                        jdlConnection.setAutoCommit(true);
                    } else {
                        jdlConnection.setAutoCommit(false);
                    }
                    for (XmlLoadType.Column column : this.loader.getColumn()) {
                        ++c;
                        Object value = column.getConstant();
                        if (value == null) {
                            value = column.getSeq() != null ? Integer.valueOf(r + column.getSeq().intValue()) : (column.getXpath() != null ? this.context.getValue(column.getXpath()) : context.getPointer(column.getXleaf()).getValue());
                        }
                        preparedStatement.setObject(c, value);
                    }
                    XmlLoader.executeBatch(preparedStatement);
                    if (jdlConnection.isAutoCommit() || r % ((Number)ncommit).intValue() != 0) continue;
                    jdlConnection.commitConnection();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            if (!jdlConnection.isAutoCommit()) {
                jdlConnection.commitConnection();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

