/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.text.MessageFormat;

public class IRMetrics {
    private static ThreadLocal<MessageFormat> doubleFormat = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat("{0,number,#.###}");
        }
    };
    int tp;
    int fp;
    int tn;
    int fn;

    public static String formatDouble(double d) {
        return doubleFormat.get().format(new Object[]{new Double(d)});
    }

    public IRMetrics() {
    }

    public IRMetrics(int tp, int fp, int tn, int fn) {
        this.tp = tp;
        this.fp = fp;
        this.tn = tn;
        this.fn = fn;
    }

    public int getTp() {
        return this.tp;
    }

    public void setTp(int tp) {
        this.tp = tp;
    }

    public int getFp() {
        return this.fp;
    }

    public void setFp(int fp) {
        this.fp = fp;
    }

    public int getTn() {
        return this.tn;
    }

    public void setTn(int tn) {
        this.tn = tn;
    }

    public int getFn() {
        return this.fn;
    }

    public void setFn(int fn) {
        this.fn = fn;
    }

    public double getPrecision() {
        return this.tp + this.fp > 0 ? (double)this.tp / (double)(this.tp + this.fp) : 0.0;
    }

    public double getRecall() {
        return this.tp + this.fn > 0 ? (double)this.tp / (double)(this.tp + this.fn) : 0.0;
    }

    public double getF1() {
        return this.getPrecision() + this.getRecall() > 0.0 ? 2.0 * this.getPrecision() * this.getRecall() / (this.getPrecision() + this.getRecall()) : 0.0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getTp()).append("\t").append(this.getFp()).append("\t").append(this.getTn()).append("\t").append(this.getFn()).append("\t").append(IRMetrics.formatDouble(this.getPrecision())).append("\t").append(IRMetrics.formatDouble(this.getRecall())).append("\t").append(IRMetrics.formatDouble(this.getF1()));
        return b.toString();
    }
}

