/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InfoContentEvaluator;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class InfoContentEvaluatorImpl
implements InfoContentEvaluator {
    private ClassifierEvaluationDao classifierEvaluationDao;
    private ConceptDao conceptDao;
    private JdbcTemplate jdbcTemplate;

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"property file");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"property file with queries and other parameters. todo desc");
        options.addOption(OptionBuilder.create((String)"prop"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            Properties props = (Properties)KernelContextHolder.getApplicationContext().getBean("ytexProperties");
            Properties propsArgs = FileUtil.loadProperties(line.getOptionValue("prop"), true);
            props.putAll((Map<?, ?>)propsArgs);
            if (!(props.containsKey("org.apache.ctakes.ytex.conceptGraphName") && props.containsKey("org.apache.ctakes.ytex.corpusName") && props.containsKey("org.apache.ctakes.ytex.freqQuery"))) {
                System.err.println("error: required parameter not specified");
                System.exit(1);
            } else {
                InfoContentEvaluator corpusEvaluator = (InfoContentEvaluator)KernelContextHolder.getApplicationContext().getBean(InfoContentEvaluator.class);
                corpusEvaluator.evaluateCorpusInfoContent(props.getProperty("org.apache.ctakes.ytex.freqQuery"), props.getProperty("org.apache.ctakes.ytex.corpusName"), props.getProperty("org.apache.ctakes.ytex.conceptGraphName"), props.getProperty("org.apache.ctakes.ytex.conceptSetName"));
                System.exit(0);
            }
        }
        catch (ParseException pe) {
            InfoContentEvaluatorImpl.printHelp(options);
            System.exit(1);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + InfoContentEvaluatorImpl.class.getName() + " calculate information content of corpus wrt concept graph", options);
    }

    @Override
    public void evaluateCorpusInfoContent(String freqQuery, String corpusName, String conceptGraphName, String conceptSetName) {
        ConceptGraph cg = this.conceptDao.getConceptGraph(conceptGraphName);
        this.classifierEvaluationDao.deleteFeatureEvaluation(corpusName, conceptSetName, null, "infocontent", 0, 0.0, conceptGraphName);
        FeatureEvaluation eval = new FeatureEvaluation();
        eval.setCorpusName(corpusName);
        if (conceptSetName != null) {
            eval.setFeatureSetName(conceptSetName);
        }
        eval.setEvaluationType("infocontent");
        eval.setParam2(conceptGraphName);
        Map<String, Double> rawFreq = this.getFrequencies(freqQuery);
        double totalFreq = 0.0;
        HashMap<String, Double> conceptFreq = new HashMap<String, Double>(cg.getConceptMap().size());
        totalFreq = this.getFrequency(cg.getConceptMap().get(cg.getRoot()), conceptFreq, rawFreq);
        List<FeatureRank> featureRankList = new ArrayList<FeatureRank>(conceptFreq.size());
        double log2inv = -1.0 / Math.log(2.0);
        for (Map.Entry cfreq : conceptFreq.entrySet()) {
            if (!((Double)cfreq.getValue() > 0.0)) continue;
            FeatureRank featureRank = new FeatureRank(eval, (String)cfreq.getKey(), log2inv * Math.log((Double)cfreq.getValue() / totalFreq));
            featureRankList.add(featureRank);
        }
        featureRankList = FeatureRank.sortFeatureRankList(featureRankList, new FeatureRank.FeatureRankDesc());
        this.classifierEvaluationDao.saveFeatureEvaluation(eval, featureRankList);
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public ConceptDao getConceptDao() {
        return this.conceptDao;
    }

    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    @Override
    public Map<String, Double> getFrequencies(String freqQuery) {
        final HashMap<String, Double> rawFreq = new HashMap<String, Double>();
        this.jdbcTemplate.query(freqQuery, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                rawFreq.put(rs.getString(1), rs.getDouble(2));
            }
        });
        return rawFreq;
    }

    double getFrequency(ConcRel parent, Map<String, Double> conceptFreq, Map<String, Double> rawFreq) {
        double dFreq = 0.0;
        if (conceptFreq.containsKey(parent.getConceptID())) {
            dFreq = conceptFreq.get(parent.getConceptID());
        } else {
            dFreq = rawFreq.containsKey(parent.getConceptID()) ? rawFreq.get(parent.getConceptID()) : 0.0;
            for (ConcRel child : parent.getChildren()) {
                dFreq += this.getFrequency(child, conceptFreq, rawFreq);
            }
            conceptFreq.put(parent.getConceptID(), dFreq);
        }
        return dFreq;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setConceptDao(ConceptDao conceptDao) {
        this.conceptDao = conceptDao;
    }

    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
    }
}

