/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.BagOfWordsDecorator;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataExporter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SparseDataExporterImpl
implements SparseDataExporter {
    private static final Log log = LogFactory.getLog(SparseDataExporterImpl.class);
    protected JdbcTemplate jdbcTemplate;
    protected KernelUtil kernelUtil;
    protected NamedParameterJdbcTemplate namedJdbcTemplate;
    protected Map<String, SparseDataFormatterFactory> nameToFormatterMap = new HashMap<String, SparseDataFormatterFactory>();
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected TransactionTemplate txTemplateNew;

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"prop");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"property file with queries and other parameters.");
        options.addOption(OptionBuilder.create((String)"prop"));
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"export format; valid values: weka, libsvm");
        options.addOption(OptionBuilder.create((String)"type"));
        if (args.length == 0) {
            SparseDataExporterImpl.printHelp(options);
        } else {
            try {
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(options, args);
                String propFile = line.getOptionValue("prop");
                String format = line.getOptionValue("type");
                SparseDataExporter exporter = (SparseDataExporter)KernelContextHolder.getApplicationContext().getBean(SparseDataExporter.class);
                exporter.exportData(propFile, format);
            }
            catch (ParseException pe) {
                SparseDataExporterImpl.printHelp(options);
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + SparseDataExporterImpl.class.getName() + " export sparse data", options);
    }

    protected void addNominalWordToInstance(SparseData sparseData, long instanceId, String word, String wordValue) {
        if (!sparseData.getInstanceIds().contains(instanceId)) {
            sparseData.getInstanceIds().add(instanceId);
        }
        SortedMap<String, String> instanceWords = sparseData.getInstanceNominalWords().get(instanceId);
        TreeSet<String> wordValueSet = (TreeSet<String>)sparseData.getNominalWordValueMap().get(word);
        if (instanceWords == null) {
            instanceWords = new TreeMap<String, String>();
            sparseData.getInstanceNominalWords().put(instanceId, instanceWords);
        }
        if (wordValueSet == null) {
            wordValueSet = new TreeSet<String>();
            sparseData.getNominalWordValueMap().put(word, wordValueSet);
        }
        instanceWords.put(word, wordValue);
        wordValueSet.add(wordValue);
    }

    protected void addNumericWordToInstance(SparseData sparseData, long instanceId, String word, double wordValue) {
        SortedMap<String, Double> words;
        if (!sparseData.getInstanceIds().contains(instanceId)) {
            sparseData.getInstanceIds().add(instanceId);
        }
        if ((words = sparseData.getInstanceNumericWords().get(instanceId)) == null) {
            words = new TreeMap<String, Double>();
            sparseData.getInstanceNumericWords().put(instanceId, words);
        }
        words.put(word, wordValue);
        sparseData.getNumericWords().add(word);
    }

    public void exportData(InstanceData instanceLabel, SparseDataFormatter formatter, Properties properties, BagOfWordsDecorator bDecorator) throws IOException {
        String scope = properties.getProperty("scope", null);
        SparseData sparseData = null;
        if (scope == null) {
            sparseData = this.loadData(instanceLabel, properties.getProperty("numericWordQuery"), properties.getProperty("nominalWordQuery"), properties.getProperty("prepareScript"), properties.getProperty("prepareScriptDelimiter", ";"), bDecorator, null, null, null);
        }
        formatter.initializeExport(instanceLabel, properties, sparseData);
        for (String label : instanceLabel.getLabelToInstanceMap().keySet()) {
            if ("label".equals(scope)) {
                sparseData = this.loadData(instanceLabel, properties.getProperty("numericWordQuery"), properties.getProperty("nominalWordQuery"), properties.getProperty("prepareScript"), properties.getProperty("prepareScriptDelimiter", ";"), bDecorator, label, null, null);
            }
            formatter.initializeLabel(label, (SortedMap)instanceLabel.getLabelToInstanceMap().get(label), properties, sparseData);
            Iterator iterator = ((SortedMap)instanceLabel.getLabelToInstanceMap().get(label)).keySet().iterator();
            while (iterator.hasNext()) {
                int run = (Integer)iterator.next();
                Iterator iterator2 = ((SortedMap)((SortedMap)instanceLabel.getLabelToInstanceMap().get(label)).get(run)).keySet().iterator();
                while (iterator2.hasNext()) {
                    int fold = (Integer)iterator2.next();
                    if (log.isInfoEnabled() && (label.length() > 0 || run > 0 || fold > 0)) {
                        log.info((Object)("exporting, label " + label + " run " + run + " fold " + fold));
                    }
                    if ("fold".equals(scope)) {
                        sparseData = this.loadData(instanceLabel, properties.getProperty("numericWordQuery"), properties.getProperty("nominalWordQuery"), properties.getProperty("prepareScript"), properties.getProperty("prepareScriptDelimiter", ";"), bDecorator, label, fold, run);
                    }
                    formatter.initializeFold(sparseData, label, run, fold, (SortedMap)((SortedMap)((SortedMap)instanceLabel.getLabelToInstanceMap().get(label)).get(run)).get(fold));
                    Iterator iterator3 = ((SortedMap)((SortedMap)((SortedMap)instanceLabel.getLabelToInstanceMap().get(label)).get(run)).get(fold)).keySet().iterator();
                    while (iterator3.hasNext()) {
                        boolean train = (Boolean)iterator3.next();
                        formatter.exportFold(sparseData, (SortedMap)((SortedMap)((SortedMap)((SortedMap)instanceLabel.getLabelToInstanceMap().get(label)).get(run)).get(fold)).get(train), train, label, 0 == run ? null : Integer.valueOf(run), 0 == fold ? null : Integer.valueOf(fold));
                    }
                    formatter.clearFold();
                }
            }
            formatter.clearLabel();
        }
    }

    @Override
    public void exportData(Properties props, SparseDataFormatter formatter, BagOfWordsDecorator bDecorator) throws IOException {
        InstanceData instanceLabel = this.getKernelUtil().loadInstances(props.getProperty("instanceClassQuery"));
        if (props.containsKey("folds")) {
            this.getKernelUtil().generateFolds(instanceLabel, props);
        }
        this.exportData(instanceLabel, formatter, props, bDecorator);
    }

    @Override
    public void exportData(String propertiesFile, String format) throws IOException, InvalidPropertiesFormatException {
        Properties props = new Properties();
        this.getKernelUtil().loadProperties(propertiesFile, props);
        this.exportData(props, this.nameToFormatterMap.get(format.toLowerCase()).getFormatter(), null);
    }

    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public Map<String, SparseDataFormatterFactory> getNameToFormatterMap() {
        return this.nameToFormatterMap;
    }

    protected void prepare(String prepareScript, String prepareScriptDelimiter, Map<String, Object> params) {
        if (prepareScript != null && prepareScript.length() > 0) {
            String[] statements;
            for (String sql : statements = prepareScript.split(prepareScriptDelimiter)) {
                if (sql == null || sql.trim().length() <= 0) continue;
                this.namedJdbcTemplate.update(sql, params);
            }
        }
    }

    protected void getNominalInstanceWords(final String sql, final String prepareScript, final String prepareScriptDelimiter, final SparseData sparseData, final Map<String, Object> params) {
        this.txTemplateNew.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus txStatus) {
                SparseDataExporterImpl.this.prepare(prepareScript, prepareScriptDelimiter, params);
                SparseDataExporterImpl.this.namedJdbcTemplate.query(sql, params, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        long instanceId = rs.getLong(1);
                        String word = rs.getString(2);
                        String wordValue = rs.getString(3);
                        SparseDataExporterImpl.this.addNominalWordToInstance(sparseData, instanceId, word, wordValue);
                    }
                });
                return null;
            }
        });
    }

    protected void getNumericInstanceWords(final String sql, final String prepareScript, final String prepareScriptDelimiter, final SparseData sparseData, final Map<String, Object> params) {
        this.txTemplateNew.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus txStatus) {
                SparseDataExporterImpl.this.prepare(prepareScript, prepareScriptDelimiter, params);
                SparseDataExporterImpl.this.namedJdbcTemplate.query(sql, params, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        long instanceId = rs.getLong(1);
                        String word = rs.getString(2);
                        double wordValue = rs.getDouble(3);
                        SparseDataExporterImpl.this.addNumericWordToInstance(sparseData, instanceId, word, wordValue);
                    }
                });
                return null;
            }
        });
    }

    public TransactionTemplate getTxTemplateNew() {
        return this.txTemplateNew;
    }

    protected SparseData loadData(InstanceData instanceLabel, String instanceNumericWordQuery, String instanceNominalWordQuery, String prepareScript, String prepareScriptDelimiter, BagOfWordsDecorator bDecorator, String label, Integer fold, Integer run) {
        SparseData sparseData = new SparseData();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (label != null && label.length() > 0) {
            params.put("label", label);
        }
        if (fold != null && fold != 0) {
            params.put("fold", fold);
        }
        if (run != null && run != 0) {
            params.put("run", run);
        }
        if (instanceNumericWordQuery != null && instanceNumericWordQuery.trim().length() > 0) {
            this.getNumericInstanceWords(instanceNumericWordQuery, prepareScript, prepareScriptDelimiter, sparseData, params);
        }
        if (bDecorator != null) {
            bDecorator.decorateNumericInstanceWords(sparseData.getInstanceNumericWords(), sparseData.getNumericWords());
        }
        if (instanceNominalWordQuery != null && instanceNominalWordQuery.trim().length() > 0) {
            this.getNominalInstanceWords(instanceNominalWordQuery, prepareScript, prepareScriptDelimiter, sparseData, params);
        }
        if (bDecorator != null) {
            bDecorator.decorateNominalInstanceWords(sparseData.getInstanceNominalWords(), sparseData.getNominalWordValueMap());
        }
        return sparseData;
    }

    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(ds);
        this.namedJdbcTemplate = new NamedParameterJdbcTemplate(ds);
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public void setNameToFormatterMap(Map<String, SparseDataFormatterFactory> nameToFormatterMap) {
        this.nameToFormatterMap = nameToFormatterMap;
    }

    public void setTxTemplateNew(TransactionTemplate txTemplateNew) {
        this.txTemplateNew = txTemplateNew;
    }
}

