/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import com.google.common.collect.BiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.BaseClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.model.SVMClassifierEvaluation;

public class SvmlinEvaluationParser
extends BaseClassifierEvaluationParser {
    private static final Log log = LogFactory.getLog(SvmlinEvaluationParser.class);
    public static Pattern pAlgo = Pattern.compile("-A\\s+(\\d)");
    public static Pattern pLambdaW = Pattern.compile("-W\\s+([\\d\\.eE-]+)");
    public static Pattern pLambaU = Pattern.compile("-U\\s+([\\d\\.eE-]+)");

    @Override
    public void parseDirectory(File dataDir, File outputDir) throws IOException {
        String optionsFile = outputDir.getPath() + File.separator + "options.properties";
        if (this.checkFileRead(optionsFile)) {
            Properties props = this.loadProps(outputDir);
            SVMClassifierEvaluation eval = new SVMClassifierEvaluation();
            eval.setAlgorithm("svmlin");
            this.parseResults(dataDir, outputDir, eval, props);
        }
    }

    private void parseResults(File dataDir, File outputDir, SVMClassifierEvaluation eval, Properties props) throws IOException {
        String fileBaseName = this.getFileBaseName(props);
        this.initClassifierEvaluation(fileBaseName, eval);
        this.initClassifierEvaluationFromProperties(props, eval);
        String options = props.getProperty(ClassifierEvaluationParser.ParseOption.EVAL_LINE.getOptionKey());
        if (options != null) {
            eval.setKernel(this.parseIntOption(pAlgo, options));
            if (eval.getKernel() == null) {
                eval.setKernel(1);
            }
            eval.setCost(this.parseDoubleOption(pLambdaW, options));
            eval.setGamma(this.parseDoubleOption(pLambaU, options));
        }
        if (fileBaseName != null && fileBaseName.length() > 0) {
            List<BaseClassifierEvaluationParser.InstanceClassInfo> listClassInfo = this.loadInstanceClassInfo(dataDir, fileBaseName + "id.txt");
            if (listClassInfo != null) {
                BiMap<Integer, String> classIdToNameMap = this.loadClassIdMap(dataDir, eval.getLabel());
                this.parseSvmlinOutput(dataDir, outputDir, eval, fileBaseName, props, listClassInfo, classIdToNameMap);
                this.storeSemiSupervised(props, eval, classIdToNameMap);
            }
        } else {
            log.warn((Object)("couldn't parse directory; kernel.label.base not defined. Dir: " + outputDir));
        }
    }

    private void parseSvmlinOutput(File dataDir, File outputDir, SVMClassifierEvaluation eval, String fileBaseName, Properties props, List<BaseClassifierEvaluationParser.InstanceClassInfo> listClassInfo, BiMap<Integer, String> classIdToNameMap) throws IOException {
        Properties codeProps = FileUtil.loadProperties(dataDir.getAbsolutePath() + "/" + fileBaseName + "code.properties", false);
        String[] codes = codeProps.getProperty("codes", "").split(",");
        TreeMap<String, double[]> codeToPredictionMap = new TreeMap<String, double[]>();
        if (codes.length == 0) {
            throw new IOException("invalid code.properties: " + fileBaseName);
        }
        String otherClassName = null;
        if (codes.length == 1) {
            otherClassName = codeProps.getProperty("classOtherName");
        }
        for (String code : codes) {
            String className = codeProps.getProperty(code + ".className");
            String codeBase = code.substring(0, code.length() - ".txt".length());
            codeToPredictionMap.put(className, this.readPredictions(outputDir.getAbsolutePath() + "/" + codeBase + ".outputs", listClassInfo.size()));
        }
        String[] classPredictions = new String[listClassInfo.size()];
        for (int i = 0; i < listClassInfo.size(); ++i) {
            if (otherClassName != null) {
                Map.Entry classToPred = codeToPredictionMap.entrySet().iterator().next();
                classPredictions[i] = ((double[])classToPred.getValue())[i] > 0.0 ? (String)classToPred.getKey() : otherClassName;
                continue;
            }
            TreeMap predToClassMap = new TreeMap();
            for (Map.Entry classToPred : codeToPredictionMap.entrySet()) {
                predToClassMap.put(((double[])classToPred.getValue())[i], classToPred.getKey());
            }
            classPredictions[i] = (String)predToClassMap.lastEntry().getValue();
        }
        boolean storeUnlabeled = "yes".equalsIgnoreCase(props.getProperty(ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getDefaultValue()));
        this.updateSemiSupervisedPredictions(eval, listClassInfo, storeUnlabeled, classPredictions, (Map<String, Integer>)classIdToNameMap.inverse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] readPredictions(String predict, int expectedSize) throws FileNotFoundException, IOException {
        BufferedReader outputReader = null;
        try {
            double[] predictions = new double[expectedSize];
            int i = 0;
            String prediction = null;
            outputReader = new BufferedReader(new FileReader(predict));
            while ((prediction = outputReader.readLine()) != null) {
                if (i < expectedSize) {
                    predictions[i++] = Double.parseDouble(prediction);
                    continue;
                }
                throw new IOException(predict + ":  more predictions than expected");
            }
            if (i < expectedSize - 1) {
                throw new IOException(predict + ":  less predictions than expected");
            }
            double[] dArray = predictions;
            return dArray;
        }
        finally {
            if (outputReader != null) {
                try {
                    outputReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

