/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ctakes.ytex.kernel.evaluator.CacheKeyGenerator;
import org.springframework.beans.factory.InitializingBean;

public class MethodCachingInterceptor
implements MethodInterceptor,
InitializingBean {
    private CacheManager cacheManager;
    private String cacheName;
    private Cache cache;
    private CacheKeyGenerator cacheKeyGenerator;
    private String methodName;

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public CacheKeyGenerator getCacheKeyGenerator() {
        return this.cacheKeyGenerator;
    }

    public void setCacheKeyGenerator(CacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object methodReturn = null;
        if (this.methodName == null || this.methodName.equals(methodInvocation.getMethod().getName())) {
            Object cacheKey = this.cacheKeyGenerator.getCacheKey(methodInvocation.getMethod(), methodInvocation.getArguments());
            Element cacheElement = this.cache.get(cacheKey);
            if (cacheElement == null) {
                methodReturn = methodInvocation.proceed();
                this.cache.put(new Element(cacheKey, (Object)((Serializable)methodReturn)));
            } else {
                methodReturn = cacheElement.getValue();
            }
        } else {
            methodReturn = methodInvocation.proceed();
        }
        return methodReturn;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void afterPropertiesSet() throws Exception {
        this.cache = this.cacheManager.getCache(this.cacheName);
    }
}

