/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.evaluator.CacheKernel;
import org.apache.ctakes.ytex.kernel.evaluator.LinKernel;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.springframework.beans.factory.InitializingBean;

public class SemanticSimKernel
extends CacheKernel
implements InitializingBean {
    private static final Log log = LogFactory.getLog(LinKernel.class);
    private Map<String, Double> conceptFilter = null;
    private ConceptSimilarityService conceptSimilarityService;
    private double cutoff = 0.0;
    private String label = null;
    private String metricNames;
    private List<ConceptSimilarityService.SimilarityMetricEnum> metrics;
    private Integer rankCutoff = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.initializeConceptFilter();
    }

    @Override
    public double evaluate(Object o1, Object o2) {
        String c1 = (String)o1;
        String c2 = (String)o2;
        double d = 0.0;
        if (c1 != null && c2 != null) {
            if (c1.equals(c2)) {
                d = 1.0;
            } else if (this.conceptFilter == null || this.conceptFilter.containsKey((String)o1) && this.conceptFilter.containsKey((String)o2)) {
                d = super.evaluate(o1, o2);
            }
        }
        return d;
    }

    public ConceptSimilarityService getConceptSimilarityService() {
        return this.conceptSimilarityService;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMetricNames() {
        return this.metricNames;
    }

    public Integer getRankCutoff() {
        return this.rankCutoff;
    }

    protected void initializeConceptFilter() {
        if (this.rankCutoff != null) {
            this.conceptFilter = new HashMap<String, Double>();
            this.cutoff = this.conceptSimilarityService.loadConceptFilter(this.label, this.rankCutoff, this.conceptFilter);
            if (this.conceptFilter.isEmpty()) {
                log.warn((Object)("no concepts that matched the threshold for supervised semantic similarity. label=" + this.label + ", rankCutoff=" + this.rankCutoff));
            }
        }
    }

    @Override
    public double innerEvaluate(Object o1, Object o2) {
        double d = 0.0;
        String c1 = (String)o1;
        String c2 = (String)o2;
        if (c1 != null && c2 != null) {
            if (c1.equals(c2)) {
                d = 1.0;
            } else {
                d = 1.0;
                ConceptPairSimilarity csim = this.conceptSimilarityService.similarity(this.metrics, c1, c2, this.conceptFilter, false);
                for (Double simVal : csim.getSimilarities()) {
                    d *= simVal.doubleValue();
                }
            }
        }
        return d;
    }

    public void setConceptSimilarityService(ConceptSimilarityService conceptSimilarityService) {
        this.conceptSimilarityService = conceptSimilarityService;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMetricNames(String metricNames) {
        this.metricNames = metricNames;
        this.metrics = new ArrayList<ConceptSimilarityService.SimilarityMetricEnum>();
        for (String metricName : metricNames.split(",")) {
            ConceptSimilarityService.SimilarityMetricEnum s = ConceptSimilarityService.SimilarityMetricEnum.valueOf(metricName);
            if (s == null) {
                throw new RuntimeException("invalid metric name: " + metricName);
            }
            this.metrics.add(s);
        }
    }

    public void setRankCutoff(Integer rankCutoff) {
        this.rankCutoff = rankCutoff;
    }
}

