/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.evaluator.CacheKernel;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;

public class SemanticTypeKernel
extends CacheKernel {
    private static final Log log = LogFactory.getLog(SemanticTypeKernel.class);
    private static final String MAINSUI = "MAINSUI";
    private static final String TUI = "TUI";
    private ConceptSimilarityService conceptSimilarityService;
    private String corpusName;
    private Map<String, Set<Integer>> cuiMainSuiMap = new HashMap<String, Set<Integer>>();
    private Map<String, BitSet> cuiTuiMap = null;
    private List<String> tuiList = null;
    private String cuiTuiQuery;
    private String mode = "MAINSUI";

    public static int getMainSem(int sui) {
        switch (sui) {
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 64: 
            case 66: {
                return 0;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                return 1;
            }
            case 103: 
            case 104: 
            case 109: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 200: {
                return 2;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 89: 
            case 102: 
            case 169: 
            case 170: 
            case 171: 
            case 185: {
                return 3;
            }
            case 74: 
            case 75: 
            case 203: {
                return 4;
            }
            case 19: 
            case 20: 
            case 33: 
            case 37: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 184: 
            case 190: 
            case 191: {
                return 5;
            }
            case 28: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                return 6;
            }
            case 83: {
                return 7;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 194: 
            case 204: {
                return 8;
            }
            case 71: 
            case 72: 
            case 73: 
            case 167: 
            case 168: {
                return 9;
            }
            case 90: 
            case 91: {
                return 10;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return 11;
            }
            case 34: 
            case 38: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return 12;
            }
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 201: {
                return 13;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                return 14;
            }
        }
        return -1;
    }

    @Override
    public double innerEvaluate(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return 0.0;
        }
        if (o1.equals(o2)) {
            return 1.0;
        }
        if (this.getMode() == null || this.getMode().length() == 0 || MAINSUI.equals(this.getMode())) {
            return this.mainSuiCheck(o1, o2);
        }
        if (TUI.equals(this.getMode())) {
            return this.tuiCheck(o1, o2);
        }
        log.error((Object)"invalid mode");
        throw new RuntimeException("invalid mode");
    }

    public ConceptSimilarityService getConceptSimilarityService() {
        return this.conceptSimilarityService;
    }

    public String getCorpusName() {
        return this.corpusName;
    }

    public String getCuiTuiQuery() {
        return this.cuiTuiQuery;
    }

    public String getMode() {
        return this.mode;
    }

    public void init() {
        this.cuiTuiMap = this.conceptSimilarityService.getCuiTuiMap();
        this.tuiList = this.conceptSimilarityService.getTuiList();
        this.initCuiMainSuiMap();
    }

    private void initCuiMainSuiMap() {
        if (this.cuiTuiMap != null) {
            for (Map.Entry<String, BitSet> cuiTui : this.cuiTuiMap.entrySet()) {
                this.cuiMainSuiMap.put(cuiTui.getKey(), this.tuiToMainSui(cuiTui.getValue()));
            }
        }
    }

    private double mainSuiCheck(Object o1, Object o2) {
        Set<Integer> tuis1 = this.cuiMainSuiMap.get((String)o1);
        Set<Integer> tuis2 = this.cuiMainSuiMap.get((String)o2);
        if (tuis1 != null && tuis2 != null && !Collections.disjoint(tuis1, tuis2)) {
            return 1.0;
        }
        return 0.0;
    }

    public void setConceptSimilarityService(ConceptSimilarityService conceptSimilarityService) {
        this.conceptSimilarityService = conceptSimilarityService;
    }

    public void setCorpusName(String corpusName) {
        this.corpusName = corpusName;
    }

    public void setCuiTuiQuery(String cuiTuiQuery) {
        this.cuiTuiQuery = cuiTuiQuery;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    private double tuiCheck(Object o1, Object o2) {
        if (this.cuiTuiMap == null) {
            return 0.0;
        }
        BitSet tuis1 = this.cuiTuiMap.get((String)o1);
        BitSet tuis2 = this.cuiTuiMap.get((String)o2);
        if (tuis1 != null && tuis2 != null && tuis1.intersects(tuis2)) {
            return 1.0;
        }
        return 0.0;
    }

    public Set<Integer> tuiToMainSui(BitSet tuis) {
        HashSet<Integer> mainSui = new HashSet<Integer>(tuis.size());
        int i = tuis.nextSetBit(0);
        while (i >= 0) {
            String tui = this.tuiList.get(i);
            mainSui.add(SemanticTypeKernel.getMainSem(Integer.parseInt(tui.substring(1))));
            i = tuis.nextSetBit(i + 1);
        }
        return mainSui;
    }
}

