/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.evaluator.Kernel;
import org.apache.ctakes.ytex.kernel.tree.Node;
import org.springframework.beans.factory.InitializingBean;

public class WeightedPolynomialMixingKernel
implements Kernel,
InitializingBean {
    private int pow = 1;
    private String attributeKey;
    private Map<Integer, Double> mapIndexWeight;
    private Kernel delegateKernel;
    private double scalingFactor;

    public int getPow() {
        return this.pow;
    }

    public void setPow(int pow) {
        this.pow = pow;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public Map<Integer, Double> getMapIndexWeight() {
        return this.mapIndexWeight;
    }

    public void setMapIndexWeight(Map<Integer, Double> mapIndexWeight) {
        this.mapIndexWeight = mapIndexWeight;
    }

    public Kernel getDelegateKernel() {
        return this.delegateKernel;
    }

    public void setDelegateKernel(Kernel delegateKernel) {
        this.delegateKernel = delegateKernel;
    }

    @Override
    public double evaluate(Object o1, Object o2) {
        double retVal = 0.0;
        if (o1 instanceof Node && o2 instanceof Node) {
            double keval = 0.0;
            for (Map.Entry<Integer, Double> indexWeight : this.mapIndexWeight.entrySet()) {
                Node n1 = this.getNodeForIndex(indexWeight.getKey(), (Node)o1);
                Node n2 = this.getNodeForIndex(indexWeight.getKey(), (Node)o2);
                if (n1 == null || n2 == null) continue;
                keval += this.delegateKernel.evaluate(n1, n2) * indexWeight.getValue();
            }
            if (keval != 0.0) {
                retVal = Math.pow(keval, this.pow) / this.scalingFactor;
            }
        }
        return retVal;
    }

    private Node getNodeForIndex(int index, Node o1) {
        for (Node n : o1.getChildren()) {
            Integer attribute = (Integer)n.getValue().get(this.attributeKey);
            if (attribute == null || index != attribute) continue;
            return n;
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        double totalWeight = 0.0;
        for (double weight : this.mapIndexWeight.values()) {
            totalWeight += weight;
        }
        this.scalingFactor = Math.pow(totalWeight, this.pow);
    }
}

